/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.config.Config;
import immersive_aircraft.entity.EngineVehicle;
import immersive_aircraft.entity.misc.Trail;
import immersive_aircraft.item.upgrade.VehicleStat;
import immersive_aircraft.util.Utils;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public abstract class AircraftEntity
extends EngineVehicle {
    protected double lastY;
    private static final List<Trail> TRAILS = Collections.emptyList();

    public AircraftEntity(EntityType<? extends AircraftEntity> entityType, Level world, boolean canExplodeOnCrash) {
        super((EntityType<? extends EngineVehicle>)entityType, world, canExplodeOnCrash);
    }

    public List<Trail> getTrails() {
        return TRAILS;
    }

    @Override
    public void m_8119_() {
        this.prevRoll = this.roll;
        if (this.m_20096_()) {
            this.setZRot(this.roll * 0.9f);
        } else {
            this.setZRot(-this.pressingInterpolatedX.getSmooth() * this.getProperties().get(VehicleStat.ROLL_FACTOR));
        }
        if (Double.isNaN(this.m_20184_().f_82479_) || Double.isNaN(this.m_20184_().f_82480_) || Double.isNaN(this.m_20184_().f_82481_)) {
            this.m_20334_(0.0, 0.0, 0.0);
        }
        super.m_8119_();
    }

    protected void convertPower(Vec3 direction) {
        Vec3 velocity = this.m_20184_();
        double drag = Math.abs(direction.m_82526_(velocity.m_82541_()));
        this.m_20256_(velocity.m_82541_().m_165921_(direction, (double)this.getProperties().get(VehicleStat.LIFT)).m_82490_(velocity.m_82553_() * (drag * (double)this.getProperties().get(VehicleStat.FRICTION) + (1.0 - (double)this.getProperties().get(VehicleStat.FRICTION)))));
    }

    @Override
    protected float getGroundDecay() {
        float gravity = Math.min(1.0f, Math.max(0.0f, this.getGravity() / -0.04f));
        float upgrade = Math.min(1.0f, this.getProperties().get(VehicleStat.ACCELERATION) * 0.5f);
        return (super.getGroundDecay() * gravity + (1.0f - gravity)) * (1.0f - upgrade) + upgrade;
    }

    @Override
    protected void updateController() {
        this.m_146922_(this.m_146908_() - this.getProperties().get(VehicleStat.YAW_SPEED) * this.pressingInterpolatedX.getSmooth());
        if (!this.m_20096_()) {
            this.m_146926_(this.m_146909_() + this.getProperties().get(VehicleStat.PITCH_SPEED) * this.pressingInterpolatedZ.getSmooth());
        }
        this.m_146926_(this.m_146909_() * (1.0f - this.getProperties().getAdditive(VehicleStat.STABILIZER)));
    }

    @Override
    protected void updateVelocity() {
        Vector3f direction = this.getForwardDirection();
        float diff = (float)(this.lastY - this.m_20186_());
        if (this.lastY != 0.0 && this.getProperties().get(VehicleStat.GLIDE_FACTOR) > 0.0f && (double)diff != 0.0) {
            this.m_20256_(this.m_20184_().m_82549_(this.toVec3d(direction).m_82490_((double)(diff * this.getProperties().get(VehicleStat.GLIDE_FACTOR) * (1.0f - Math.abs(direction.y))))));
        }
        this.lastY = (float)this.m_20186_();
        this.convertPower(this.toVec3d(direction));
        this.applyFriction();
        if (this.m_20096_()) {
            this.m_146926_((this.m_146909_() + this.getProperties().get(VehicleStat.GROUND_PITCH)) * 0.9f - this.getProperties().get(VehicleStat.GROUND_PITCH));
        } else {
            Vector3f effect = this.getWindEffect();
            this.m_146926_(this.m_146909_() + effect.x);
            this.m_146922_(this.m_146908_() + effect.z);
            float offsetStrength = 0.005f;
            this.m_20256_(this.m_20184_().m_82520_((double)(effect.x * offsetStrength), 0.0, (double)(effect.z * offsetStrength)));
        }
    }

    @Override
    public void chill() {
        this.lastY = 0.0;
    }

    public float getWindStrength() {
        float sensitivity = this.getProperties().get(VehicleStat.WIND);
        float thundering = this.m_9236_().m_46722_(0.0f);
        float raining = this.m_9236_().m_46661_(0.0f);
        float weather = (float)((double)Config.getInstance().windClearWeather + this.m_20184_().m_82553_() + (double)(thundering * Config.getInstance().windThunderWeather) + (double)(raining * Config.getInstance().windRainWeather));
        return weather * sensitivity;
    }

    public Vector3f getWindEffect() {
        float wind = this.getWindStrength();
        float nx = (float)(Utils.cosNoise((double)this.f_19797_ / 20.0 / (double)this.getProperties().get(VehicleStat.MASS)) * (double)wind);
        float nz = (float)(Utils.cosNoise((double)this.f_19797_ / 21.0 / (double)this.getProperties().get(VehicleStat.MASS)) * (double)wind);
        return new Vector3f(nx, 0.0f, nz);
    }
}

