/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.cobalt.network;

import immersive_aircraft.cobalt.network.Message;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public abstract class NetworkHandler {
    private static Impl INSTANCE;

    public static <T extends Message> void registerMessage(Class<T> msg, Function<FriendlyByteBuf, T> constructor) {
        INSTANCE.registerMessage("ic_air", msg, constructor);
    }

    public static <T extends Message> void registerMessage(String namespace, Class<T> msg, Function<FriendlyByteBuf, T> constructor) {
        INSTANCE.registerMessage(namespace, msg, constructor);
    }

    public static void sendToServer(Message m) {
        INSTANCE.sendToServer(m);
    }

    public static void sendToPlayer(Message m, ServerPlayer e) {
        INSTANCE.sendToPlayer(m, e);
    }

    public static void sendToTrackingPlayers(Message m, Entity origin) {
        INSTANCE.sendToTrackingPlayers(m, origin);
    }

    public static abstract class Impl {
        protected Impl() {
            INSTANCE = this;
        }

        public abstract <T extends Message> void registerMessage(String var1, Class<T> var2, Function<FriendlyByteBuf, T> var3);

        public abstract void sendToServer(Message var1);

        public abstract void sendToPlayer(Message var1, ServerPlayer var2);

        public abstract void sendToTrackingPlayers(Message var1, Entity var2);
    }
}

