/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.justmobheads_common_forge.events;

import com.mojang.authlib.GameProfile;
import com.natamus.collective_common_forge.functions.StringFunctions;
import com.natamus.justmobheads_common_forge.config.ConfigHandler;
import com.natamus.justmobheads_common_forge.util.HeadData;
import com.natamus.justmobheads_common_forge.util.MobHeads;
import java.util.UUID;
import joptsimple.internal.Strings;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PlayerHeadItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class HeadDropEvent {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void mobItemDrop(Level world, Entity entity, DamageSource damageSource) {
        ItemEntity mobhead;
        int looting;
        TamableAnimal te;
        if (world.f_46443_) {
            return;
        }
        if (ConfigHandler.onlyDropHeadsByChargedCreeper || ConfigHandler.onlyDropHeadsByPlayerKill) {
            Entity sourceentity = damageSource.m_7640_();
            if (ConfigHandler.onlyDropHeadsByChargedCreeper) {
                if (!(sourceentity instanceof Creeper)) return;
                Creeper creeper = (Creeper)sourceentity;
                if (!creeper.m_7090_()) {
                    return;
                }
            } else if (ConfigHandler.onlyDropHeadsByPlayerKill && !(sourceentity instanceof Player)) {
                return;
            }
        }
        if (ConfigHandler.onlyAdultMobsDropTheirHead && entity instanceof TamableAnimal && (te = (TamableAnimal)entity).m_6162_()) {
            return;
        }
        String mobname = MobHeads.getName(entity);
        if (mobname.equals("")) {
            return;
        }
        double extrachance = 0.0;
        Entity source = damageSource.m_7639_();
        if (ConfigHandler.enableLootingEnchant && source instanceof Player && (looting = EnchantmentHelper.m_44930_((LivingEntity)((LivingEntity)source))) > 0) {
            extrachance = 0.025 + (double)((float)looting / 100.0f);
        }
        Object headname = "";
        if (mobname.equals("creeper") || mobname.equals("zombie") || mobname.equals("skeleton")) {
            if (!ConfigHandler.enableStandardHeads) return;
            headname = mobname.substring(0, 1).toUpperCase() + mobname.substring(1) + " Head";
        }
        double num = Math.random();
        if (ConfigHandler.mobSpecificDropChances) {
            double chance = -1.0;
            if (((String)headname).equals("")) {
                if (HeadData.headChances.containsKey(mobname)) {
                    chance = HeadData.headChances.get(mobname);
                }
            } else {
                chance = ConfigHandler.creeperSkeletonZombieDropChance;
            }
            if (chance == -1.0 ? num > ConfigHandler.overallDropChance + extrachance : num > chance + extrachance) {
                return;
            }
        } else if (num > ConfigHandler.overallDropChance + extrachance) {
            return;
        }
        BlockPos pos = entity.m_20183_();
        if (((String)headname).equals("")) {
            ItemStack headstack = MobHeads.getMobHead(mobname, 1);
            if (headstack == null) {
                return;
            }
            mobhead = new ItemEntity(world, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), headstack);
        } else {
            mobhead = new ItemEntity(world, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), MobHeads.getStandardHead((String)headname));
        }
        world.m_7967_((Entity)mobhead);
    }

    public static void onItemPickup(Level level, Player player, ItemStack itemStack) {
        CompoundTag compoundTagSkullOwner;
        if (level.f_46443_) {
            return;
        }
        Item item = itemStack.m_41720_();
        if (!(item instanceof PlayerHeadItem)) {
            return;
        }
        String headName = "";
        CompoundTag compoundTagItemStack = itemStack.m_41783_();
        if (compoundTagItemStack == null) {
            return;
        }
        if (compoundTagItemStack.m_128425_("SkullOwner", 8)) {
            headName = compoundTagItemStack.m_128461_("SkullOwner");
        } else if (compoundTagItemStack.m_128425_("SkullOwner", 10) && (compoundTagSkullOwner = compoundTagItemStack.m_128469_("SkullOwner")).m_128425_("Name", 8)) {
            headName = compoundTagSkullOwner.m_128461_("Name");
        }
        if (headName.isEmpty()) {
            return;
        }
        String dataHeadName = headName.toLowerCase().replace(" ", "_");
        if (!HeadData.headTextureData.containsKey(dataHeadName)) {
            return;
        }
        if (!compoundTagItemStack.m_128441_("note_block_sound") && HeadData.headNoteBlockSounds.containsKey(dataHeadName)) {
            compoundTagItemStack.m_128359_("note_block_sound", HeadData.headNoteBlockSounds.get(dataHeadName));
        }
        itemStack.m_41714_((Component)Component.m_237113_((String)(StringFunctions.capitalizeEveryWord((String)headName.replace("_", " ")) + " Head")));
    }

    public static boolean onPlayerHeadBreak(Level world, Player player, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        Block block = state.m_60734_();
        if (block instanceof SkullBlock || block instanceof WallSkullBlock) {
            ItemStack named_headstack;
            CompoundTag compoundTagSkullOwner;
            if (player.m_7500_()) {
                return true;
            }
            BlockEntity targetBlockEntity = world.m_7702_(pos);
            if (!(targetBlockEntity instanceof SkullBlockEntity)) {
                return true;
            }
            SkullBlockEntity sbe = (SkullBlockEntity)targetBlockEntity;
            if (sbe == null) {
                return true;
            }
            String headName = "";
            CompoundTag compoundTagItemStack = targetBlockEntity.m_5995_();
            if (compoundTagItemStack.m_128425_("SkullOwner", 8)) {
                headName = compoundTagItemStack.m_128461_("SkullOwner");
            } else if (compoundTagItemStack.m_128425_("SkullOwner", 10) && (compoundTagSkullOwner = compoundTagItemStack.m_128469_("SkullOwner")).m_128425_("Name", 8)) {
                headName = compoundTagSkullOwner.m_128461_("Name");
            }
            if (!headName.isEmpty()) {
                return true;
            }
            GameProfile profile = sbe.m_59779_();
            if (profile == null) {
                return true;
            }
            if (!Strings.isNullOrEmpty((String)profile.getName())) {
                return true;
            }
            UUID uuid = profile.getId();
            if (uuid == null) {
                return true;
            }
            String headid = uuid.toString();
            String correctheadname = "";
            for (String headname : HeadData.headTextureData.keySet()) {
                String headnameid = (String)HeadData.headTextureData.get(headname).getFirst();
                if (!headid.equals(headnameid)) continue;
                correctheadname = headname;
                break;
            }
            if ((named_headstack = MobHeads.getMobHead(correctheadname, 1)) != null) {
                world.m_46961_(pos, false);
                world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_() + 0.5, (double)pos.m_123343_(), named_headstack));
                return false;
            }
        }
        return true;
    }
}

