/*
 * Decompiled with CFR 0.152.
 */
package com.example.loginsystem;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod(value="loginsystem")
public class LoginSystem {
    private final HashMap<UUID, String> playerPasswords = new HashMap();
    private final HashMap<UUID, Boolean> loggedIn = new HashMap();
    private final HashMap<UUID, double[]> originalPositions = new HashMap();
    private final HashSet<UUID> alreadyDisconnected = new HashSet();
    private final HashMap<UUID, ItemStack[]> savedInventories = new HashMap();
    private final Properties config = new Properties();
    private final File configFile = new File("config/loginsystem.properties");
    private final File passwordFile = new File("config/passwords.txt");
    private boolean enableDatabase;
    private String jdbcUrl;

    public LoginSystem() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.loadConfig();
        this.enableDatabase = Boolean.parseBoolean(this.config.getProperty("enableDatabase", "false"));
        this.jdbcUrl = this.config.getProperty("jdbcurl", "jdbc:sqlite:login_system.db");
        if (this.enableDatabase) {
            this.loadDatabaseDriver();
            this.initDatabase();
            this.loadPasswordsFromDB();
        } else {
            this.loadPasswordsFromFile();
        }
    }

    private void loadConfig() {
        File configDir = new File("config");
        if (!configDir.exists()) {
            configDir.mkdir();
        }
        if (!this.configFile.exists()) {
            String configContent = "# \ud83d\ude80 Login System Mod Configuration File \ud83d\ude80\n# This file contains configuration settings for the Login System mod.\n# Adjust the values below according to your server's needs.\n# \ud83d\ude4f Your donation helps me continue improving this mod!\n\n# ----------------------------\n# General Settings\n# ----------------------------\n# Maximum time (in seconds) a player can remain in the waiting area before being disconnected.\nloginTimeout=60\n\n# ----------------------------\n# Messages\n# ----------------------------\n# Message when registration is successful.\nmessage.registerSuccess=Registration successful! \ud83c\udf89\n# Message when login is successful.\nmessage.loginSuccess=Login successful! \u2705\n# Message for incorrect password.\nmessage.incorrectPassword=Incorrect password! \u274c\n# Message when a player tries to login without registering.\nmessage.notRegistered=You are not registered! Use /register first. \u26a0\ufe0f\n# Message when a player attempts to register again.\nmessage.alreadyRegistered=You are already registered! \u26a0\ufe0f\n# Message when a player is kicked for timeout.\nmessage.kickTimeout=You were kicked for not logging in! \u23f0\n\n# ----------------------------\n# Visual Effects & Inventory Control\n# ----------------------------\n# If true, applies a blindness effect to unlogged players.\napplyBlindness=true\n# Duration (in ticks) for the blindness effect (20 ticks = 1 second).\nblindnessDuration=40\n# If true, the player's inventory will be hidden until they log in.\nhideInventory=true\n\n# ----------------------------\n# Database Settings\n# ----------------------------\n# If true, the mod uses a database to store passwords. If false, a local file is used.\nenableDatabase=true\n# JDBC URL for database connection. For SQLite: jdbc:sqlite:login_system.db\n# For MySQL, example: jdbc:mysql://localhost:3306/your_database?user=root&password=yourpassword\njdbcurl=jdbc:mysql://localhost:3306/your_database?user=root&password=yourpassword\n\n# ----------------------------\n# Waiting Area Settings\n# ----------------------------\n# Coordinates for the waiting area where unlogged players will be teleported.\nwaitingAreaX=0\nwaitingAreaY=100\nwaitingAreaZ=0\n";
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.configFile));){
                writer.write(configContent);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try (FileInputStream in = new FileInputStream(this.configFile);){
            this.config.load(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadDatabaseDriver() {
        block10: {
            try {
                if (this.jdbcUrl.startsWith("jdbc:mysql")) {
                    try {
                        Class.forName("com.mysql.cj.jdbc.Driver");
                        break block10;
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("MySQL JDBC driver not found! Please install the MySQL JDBC mod from: https://www.curseforge.com/minecraft/mc-mods/mysql-jdbc", e);
                    }
                }
                if (this.jdbcUrl.startsWith("jdbc:sqlite")) {
                    try {
                        Class.forName("org.sqlite.JDBC");
                        break block10;
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("SQLite JDBC driver not found! Please install the SQLite JDBC mod from: https://www.curseforge.com/minecraft/mc-mods/sqlite-jdbc", e);
                    }
                }
                if (!this.jdbcUrl.startsWith("jdbc:postgresql")) break block10;
                try {
                    Class.forName("org.postgresql.Driver");
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("PostgreSQL JDBC driver not found! Please install a PostgreSQL JDBC mod", e);
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw new RuntimeException("Database driver not found! Please make sure you have installed the correct JDBC mod for your database type:\n- MySQL: https://www.curseforge.com/minecraft/mc-mods/mysql-jdbc\n- SQLite: https://www.curseforge.com/minecraft/mc-mods/sqlite-jdbc", e);
            }
        }
    }

    private void initDatabase() {
        block14: {
            try (Connection conn = DriverManager.getConnection(this.jdbcUrl);){
                if (conn == null) break block14;
                String sql = "CREATE TABLE IF NOT EXISTS player_passwords (uuid VARCHAR(36) PRIMARY KEY, password TEXT NOT NULL)";
                try (Statement stmt = conn.createStatement();){
                    stmt.execute(sql);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void loadPasswordsFromDB() {
        if (!this.enableDatabase) {
            return;
        }
        try (Connection conn = DriverManager.getConnection(this.jdbcUrl);){
            String createTable = "CREATE TABLE IF NOT EXISTS player_passwords (uuid VARCHAR(36) PRIMARY KEY, password TEXT NOT NULL)";
            try (Statement stmt = conn.createStatement();){
                stmt.execute(createTable);
            }
            this.playerPasswords.clear();
            String sql = "SELECT uuid, password FROM player_passwords";
            try (Statement stmt = conn.createStatement();
                 ResultSet rs = stmt.executeQuery(sql);){
                int count = 0;
                while (rs.next()) {
                    UUID uuid = UUID.fromString(rs.getString("uuid"));
                    String password = rs.getString("password");
                    this.playerPasswords.put(uuid, password);
                    ++count;
                }
                System.out.println("LoginSystem: Loaded " + count + " passwords from database.");
            }
        }
        catch (SQLException e) {
            System.err.println("LoginSystem: Database error while loading passwords!");
            e.printStackTrace();
            throw new RuntimeException("Failed to load passwords from database", e);
        }
    }

    private void savePasswordToDB(UUID uuid, String password) {
        if (!this.enableDatabase) {
            return;
        }
        try (Connection conn = DriverManager.getConnection(this.jdbcUrl);){
            String updateSql = "INSERT INTO player_passwords (uuid, password) VALUES (?, ?) ON DUPLICATE KEY UPDATE password = VALUES(password)";
            try (PreparedStatement pstmt = conn.prepareStatement(updateSql);){
                pstmt.setString(1, uuid.toString());
                pstmt.setString(2, password);
                pstmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            System.err.println("LoginSystem: Failed to save password for player " + String.valueOf(uuid));
            e.printStackTrace();
        }
    }

    private void deletePasswordFromDB(UUID uuid) {
        try (Connection conn = DriverManager.getConnection(this.jdbcUrl);){
            String sql = "DELETE FROM player_passwords WHERE uuid = ?";
            try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                pstmt.setString(1, uuid.toString());
                pstmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void loadPasswordsFromFile() {
        if (!this.passwordFile.exists()) {
            System.out.println("LoginSystem: No password file found, starting fresh.");
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(this.passwordFile));){
            String line;
            this.playerPasswords.clear();
            int count = 0;
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split(":");
                if (parts.length != 2) continue;
                this.playerPasswords.put(UUID.fromString(parts[0]), parts[1]);
                ++count;
            }
            System.out.println("LoginSystem: Loaded " + count + " passwords from file.");
        }
        catch (IOException e) {
            System.err.println("LoginSystem: Error reading password file!");
            e.printStackTrace();
        }
    }

    private void savePasswordsToFile() {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.passwordFile));){
            int count = 0;
            for (UUID uuid : this.playerPasswords.keySet()) {
                writer.write(uuid.toString() + ":" + this.playerPasswords.get(uuid));
                writer.newLine();
                ++count;
            }
            System.out.println("LoginSystem: Saved " + count + " passwords to file.");
        }
        catch (IOException e) {
            System.err.println("LoginSystem: Error writing password file!");
            e.printStackTrace();
        }
    }

    private String hashPassword(String password) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] encodedHash = digest.digest(password.getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            for (byte b : encodedHash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 algorithm not found!", e);
        }
    }

    private void restoreInventory(ServerPlayer player) {
        UUID playerId = player.m_20148_();
        if (this.savedInventories.containsKey(playerId)) {
            ItemStack[] items = this.savedInventories.get(playerId);
            for (int i = 0; i < items.length; ++i) {
                player.m_150109_().m_6836_(i, items[i]);
            }
            this.savedInventories.remove(playerId);
            player.m_150109_().m_6596_();
        }
    }

    private void removeBlindness(ServerPlayer player) {
        player.m_21195_(MobEffects.f_19610_);
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"register").then(Commands.m_82129_((String)"password", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"confirmPassword", (ArgumentType)StringArgumentType.string()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            UUID playerId = player.m_20148_();
            String password = StringArgumentType.getString((CommandContext)context, (String)"password");
            String confirmPassword = StringArgumentType.getString((CommandContext)context, (String)"confirmPassword");
            if (this.playerPasswords.containsKey(playerId)) {
                player.m_213846_((Component)Component.m_237113_((String)this.config.getProperty("message.alreadyRegistered")).m_130940_(ChatFormatting.RED));
                return 0;
            }
            if (!password.equals(confirmPassword)) {
                player.m_213846_((Component)Component.m_237113_((String)"Passwords do not match!").m_130940_(ChatFormatting.RED));
                return 0;
            }
            String hashedPassword = this.hashPassword(password);
            this.playerPasswords.put(playerId, hashedPassword);
            if (this.enableDatabase) {
                this.savePasswordToDB(playerId, hashedPassword);
            } else {
                this.savePasswordsToFile();
            }
            this.loggedIn.put(playerId, true);
            player.m_20242_(false);
            this.restoreInventory(player);
            this.removeBlindness(player);
            if (this.originalPositions.containsKey(playerId)) {
                double[] orig = this.originalPositions.get(playerId);
                player.m_8999_((ServerLevel)player.m_20193_(), orig[0], orig[1], orig[2], player.m_146908_(), player.m_146909_());
                this.originalPositions.remove(playerId);
            }
            player.m_213846_((Component)Component.m_237113_((String)this.config.getProperty("message.registerSuccess")).m_130940_(ChatFormatting.GREEN));
            return 1;
        }))));
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"login").then(Commands.m_82129_((String)"password", (ArgumentType)StringArgumentType.string()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            UUID playerId = player.m_20148_();
            if (this.loggedIn.getOrDefault(playerId, false).booleanValue()) {
                player.m_213846_((Component)Component.m_237113_((String)"You are already logged in!").m_130940_(ChatFormatting.RED));
                return 0;
            }
            if (!this.playerPasswords.containsKey(playerId)) {
                player.m_213846_((Component)Component.m_237113_((String)this.config.getProperty("message.notRegistered")).m_130940_(ChatFormatting.RED));
                return 0;
            }
            String password = StringArgumentType.getString((CommandContext)context, (String)"password");
            String hashedPassword = this.hashPassword(password);
            if (!this.playerPasswords.get(playerId).equals(hashedPassword)) {
                player.m_213846_((Component)Component.m_237113_((String)"Incorrect password!").m_130940_(ChatFormatting.RED));
                return 0;
            }
            this.loggedIn.put(playerId, true);
            player.m_20242_(false);
            this.restoreInventory(player);
            this.removeBlindness(player);
            if (this.originalPositions.containsKey(playerId)) {
                double[] orig = this.originalPositions.get(playerId);
                player.m_8999_((ServerLevel)player.m_20193_(), orig[0], orig[1], orig[2], player.m_146908_(), player.m_146909_());
                this.originalPositions.remove(playerId);
            }
            player.m_213846_((Component)Component.m_237113_((String)this.config.getProperty("message.loginSuccess")).m_130940_(ChatFormatting.GREEN));
            return 1;
        })));
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"changepassword").then(Commands.m_82129_((String)"oldPassword", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"newPassword", (ArgumentType)StringArgumentType.string()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            UUID playerId = player.m_20148_();
            String oldPassword = StringArgumentType.getString((CommandContext)context, (String)"oldPassword");
            String newPassword = StringArgumentType.getString((CommandContext)context, (String)"newPassword");
            if (!this.loggedIn.getOrDefault(playerId, false).booleanValue()) {
                player.m_213846_((Component)Component.m_237113_((String)"You must be logged in to change your password.").m_130940_(ChatFormatting.RED));
                return 0;
            }
            String hashedOld = this.hashPassword(oldPassword);
            if (!this.playerPasswords.get(playerId).equals(hashedOld)) {
                player.m_213846_((Component)Component.m_237113_((String)"Old password is incorrect.").m_130940_(ChatFormatting.RED));
                return 0;
            }
            String hashedNew = this.hashPassword(newPassword);
            this.playerPasswords.put(playerId, hashedNew);
            if (this.enableDatabase) {
                this.savePasswordToDB(playerId, hashedNew);
            } else {
                this.savePasswordsToFile();
            }
            player.m_213846_((Component)Component.m_237113_((String)"Password changed successfully!").m_130940_(ChatFormatting.GREEN));
            return 1;
        }))));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"loadmin").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"info").then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String targetPlayerName = StringArgumentType.getString((CommandContext)context, (String)"player");
            UUID targetUUID = UUID.nameUUIDFromBytes(("OfflinePlayer:" + targetPlayerName).getBytes(StandardCharsets.UTF_8));
            String pass = this.playerPasswords.get(targetUUID);
            if (pass != null) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Player " + targetPlayerName + " has password: " + pass)).m_130940_(ChatFormatting.AQUA), false);
            } else {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("No password found for player " + targetPlayerName)).m_130940_(ChatFormatting.RED), false);
            }
            return 1;
        })))).then(Commands.m_82127_((String)"delete").then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String targetPlayerName = StringArgumentType.getString((CommandContext)context, (String)"player");
            UUID targetUUID = UUID.nameUUIDFromBytes(("OfflinePlayer:" + targetPlayerName).getBytes(StandardCharsets.UTF_8));
            if (this.playerPasswords.containsKey(targetUUID)) {
                this.playerPasswords.remove(targetUUID);
                if (this.enableDatabase) {
                    this.deletePasswordFromDB(targetUUID);
                } else {
                    this.savePasswordsToFile();
                }
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Deleted password for player " + targetPlayerName)).m_130940_(ChatFormatting.GREEN), false);
            } else {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("No password found for player " + targetPlayerName)).m_130940_(ChatFormatting.RED), false);
            }
            return 1;
        }))));
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer newPlayer = (ServerPlayer)event.getEntity();
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        UUID newPlayerUUID = newPlayer.m_20148_();
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            if (player == newPlayer || !player.m_20148_().equals(newPlayerUUID)) continue;
            if (!this.alreadyDisconnected.contains(newPlayerUUID)) {
                newPlayer.f_8906_.m_9942_((Component)Component.m_237113_((String)"A player with that name is already online.").m_130940_(ChatFormatting.RED));
                this.alreadyDisconnected.add(newPlayerUUID);
            }
            return;
        }
        this.originalPositions.put(newPlayerUUID, new double[]{newPlayer.m_20185_(), newPlayer.m_20186_(), newPlayer.m_20189_()});
        double waitingX = Double.parseDouble(this.config.getProperty("waitingAreaX", "0"));
        double waitingY = Double.parseDouble(this.config.getProperty("waitingAreaY", "100"));
        double waitingZ = Double.parseDouble(this.config.getProperty("waitingAreaZ", "0"));
        newPlayer.m_8999_((ServerLevel)newPlayer.m_20193_(), waitingX, waitingY, waitingZ, newPlayer.m_146908_(), newPlayer.m_146909_());
        this.loggedIn.put(newPlayerUUID, false);
        newPlayer.m_213846_((Component)Component.m_237113_((String)"Please register or login using /register <password> <confirmPassword> or /login <password>").m_130940_(ChatFormatting.YELLOW));
        if (Boolean.parseBoolean(this.config.getProperty("hideInventory", "true"))) {
            int containerSize = newPlayer.m_150109_().m_6643_();
            ItemStack[] savedItems = new ItemStack[containerSize];
            for (int i = 0; i < containerSize; ++i) {
                savedItems[i] = newPlayer.m_150109_().m_8020_(i).m_41777_();
            }
            this.savedInventories.put(newPlayerUUID, savedItems);
            newPlayer.m_150109_().m_6211_();
        }
        if (Boolean.parseBoolean(this.config.getProperty("applyBlindness", "true"))) {
            int duration = Integer.parseInt(this.config.getProperty("blindnessDuration", "40"));
            newPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19610_, duration, 0, false, false));
        }
        int timeout = Integer.parseInt(this.config.getProperty("loginTimeout", "60")) * 1000;
        new Thread(() -> {
            try {
                Thread.sleep(timeout);
                if (!this.loggedIn.getOrDefault(newPlayerUUID, false).booleanValue()) {
                    server.execute(() -> {
                        if (!this.alreadyDisconnected.contains(newPlayerUUID)) {
                            newPlayer.f_8906_.m_9942_((Component)Component.m_237113_((String)this.config.getProperty("message.kickTimeout", "You were kicked for not logging in!")).m_130940_(ChatFormatting.RED));
                            this.alreadyDisconnected.add(newPlayerUUID);
                        }
                    });
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }).start();
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        UUID playerId = event.getEntity().m_20148_();
        this.loggedIn.remove(playerId);
        this.alreadyDisconnected.remove(playerId);
        this.savedInventories.remove(playerId);
        this.originalPositions.remove(playerId);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        System.out.println("LoginSystem: Server is starting, loading passwords...");
        if (this.enableDatabase) {
            try {
                this.loadPasswordsFromDB();
                System.out.println("LoginSystem: Successfully loaded " + this.playerPasswords.size() + " passwords from database.");
            }
            catch (Exception e) {
                System.err.println("LoginSystem: Failed to load passwords from database!");
                e.printStackTrace();
                throw new RuntimeException("Failed to load passwords from database", e);
            }
        } else {
            this.loadPasswordsFromFile();
            System.out.println("LoginSystem: Successfully loaded " + this.playerPasswords.size() + " passwords from file.");
        }
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        System.out.println("LoginSystem: Server is stopping, saving passwords...");
        if (this.enableDatabase) {
            try {
                System.out.println("LoginSystem: Saving " + this.playerPasswords.size() + " passwords to database...");
                this.saveAllPasswordsToDB();
                System.out.println("LoginSystem: All passwords saved successfully to database!");
            }
            catch (Exception e) {
                System.err.println("LoginSystem: Failed to save to database!");
                e.printStackTrace();
                throw new RuntimeException("Failed to save passwords to database", e);
            }
        } else {
            this.savePasswordsToFile();
            System.out.println("LoginSystem: Saved " + this.playerPasswords.size() + " passwords to file.");
        }
    }

    private void saveAllPasswordsToDB() {
        if (!this.enableDatabase) {
            return;
        }
        try (Connection conn = DriverManager.getConnection(this.jdbcUrl);){
            String createTempTable = "CREATE TABLE IF NOT EXISTS temp_passwords (uuid VARCHAR(36) PRIMARY KEY, password TEXT NOT NULL)";
            try (Statement stmt = conn.createStatement();){
                stmt.execute(createTempTable);
            }
            String insertSql = "INSERT INTO temp_passwords (uuid, password) VALUES (?, ?) ON DUPLICATE KEY UPDATE password = VALUES(password)";
            try (PreparedStatement pstmt = conn.prepareStatement(insertSql);){
                int count = 0;
                for (UUID uuid : this.playerPasswords.keySet()) {
                    pstmt.setString(1, uuid.toString());
                    pstmt.setString(2, this.playerPasswords.get(uuid));
                    pstmt.executeUpdate();
                    ++count;
                }
                System.out.println("LoginSystem: Saved " + count + " passwords to database.");
            }
            try (Statement stmt = conn.createStatement();){
                stmt.execute("DROP TABLE IF EXISTS player_passwords");
                stmt.execute("RENAME TABLE temp_passwords TO player_passwords");
            }
        }
        catch (SQLException e) {
            System.err.println("LoginSystem: Failed to save passwords to database!");
            e.printStackTrace();
            throw new RuntimeException("Failed to save passwords to database", e);
        }
    }

    @SubscribeEvent
    public void onPlayerDropItem(ItemTossEvent event) {
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        UUID playerId = player.m_20148_();
        if (!this.loggedIn.getOrDefault(playerId, false).booleanValue()) {
            event.setCanceled(true);
            ItemStack droppedItem = event.getEntity().m_32055_().m_41777_();
            boolean added = player.m_150109_().m_36054_(droppedItem);
            player.m_150109_().m_6596_();
            if (!added) {
                player.m_213846_((Component)Component.m_237113_((String)"Your inventory is full, so the item couldn't be returned.").m_130940_(ChatFormatting.RED));
            } else {
                player.m_213846_((Component)Component.m_237113_((String)"You must be logged in to drop items. Your item has been returned.").m_130940_(ChatFormatting.YELLOW));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerHurt(LivingHurtEvent event) {
        ServerPlayer player;
        UUID playerId;
        if (event.getEntity() instanceof ServerPlayer && !this.loggedIn.getOrDefault(playerId = (player = (ServerPlayer)event.getEntity()).m_20148_(), false).booleanValue()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        ServerPlayer player;
        UUID playerId;
        if (event.getPlayer() instanceof ServerPlayer && !this.loggedIn.getOrDefault(playerId = (player = (ServerPlayer)event.getPlayer()).m_20148_(), false).booleanValue()) {
            event.setCanceled(true);
            ((ServerLevel)event.getLevel()).m_7731_(event.getPos(), event.getState(), 3);
            player.m_213846_((Component)Component.m_237113_((String)"You must be logged in to break blocks!").m_130940_(ChatFormatting.RED));
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ServerPlayer player;
        UUID playerId;
        if (!event.player.m_20193_().m_5776_() && event.phase == TickEvent.Phase.END && !this.loggedIn.getOrDefault(playerId = (player = (ServerPlayer)event.player).m_20148_(), false).booleanValue()) {
            double dz;
            double dy;
            double waitingX = Double.parseDouble(this.config.getProperty("waitingAreaX", "0"));
            double waitingY = Double.parseDouble(this.config.getProperty("waitingAreaY", "100"));
            double waitingZ = Double.parseDouble(this.config.getProperty("waitingAreaZ", "0"));
            double dx = player.m_20185_() - waitingX;
            if (dx * dx + (dy = player.m_20186_() - waitingY) * dy + (dz = player.m_20189_() - waitingZ) * dz > 1.0) {
                player.m_8999_((ServerLevel)player.m_20193_(), waitingX, waitingY, waitingZ, player.m_146908_(), player.m_146909_());
                player.m_213846_((Component)Component.m_237113_((String)"You must be logged in to move!").m_130940_(ChatFormatting.RED));
            }
            if (Boolean.parseBoolean(this.config.getProperty("applyBlindness", "true")) && !player.m_21023_(MobEffects.f_19610_)) {
                int duration = Integer.parseInt(this.config.getProperty("blindnessDuration", "40"));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, duration, 0, false, false));
            }
        }
    }
}

