/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.justmobheads_common_fabric.util;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_fabric.functions.EntityFunctions;
import com.natamus.collective_common_fabric.functions.HeadFunctions;
import com.natamus.justmobheads_common_fabric.util.HeadData;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1438;
import net.minecraft.class_1451;
import net.minecraft.class_1453;
import net.minecraft.class_1463;
import net.minecraft.class_1472;
import net.minecraft.class_1498;
import net.minecraft.class_1501;
import net.minecraft.class_1548;
import net.minecraft.class_1641;
import net.minecraft.class_1646;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3850;
import net.minecraft.class_3852;
import net.minecraft.class_3986;
import net.minecraft.class_4019;
import net.minecraft.class_5762;
import net.minecraft.class_7102;
import net.minecraft.class_7106;
import net.minecraft.class_7375;

public class MobHeads {
    static List<String> horsetypes = Arrays.asList("white", "creamy", "chestnut", "brown", "black", "gray", "dark_brown");
    static List<String> llamatypes = Arrays.asList("creamy", "white", "brown", "gray");
    static List<String> parrottypes = Arrays.asList("red", "blue", "green", "cyan", "gray");
    static List<String> rabbittypes = Arrays.asList("brown", "white", "black", "black_and_white", "gold", "salt_and_pepper");
    static List<String> cattypes = Arrays.asList("tabby", "tuxedo", "red", "siamese", "british_shorthair", "calico", "persian", "ragdoll", "white", "jellie", "black");
    static List<String> axolotltypes = Arrays.asList("lucy", "wild", "gold", "cyan", "blue");

    public static class_1799 getMobHead(String mobName, Integer amount) {
        Pair<String, String> textureData = HeadData.headTextureData.get(mobName);
        if (textureData == null) {
            return null;
        }
        String headNoteBlockSound = HeadData.headNoteBlockSounds.get(mobName) == null ? "" : HeadData.headNoteBlockSounds.get(mobName);
        String formattedMobName = MobHeads.capitalizeFirst(mobName.replace("_", " "));
        String oldid = (String)textureData.getFirst();
        String texture = (String)textureData.getSecond();
        class_1799 texturedHeadStack = HeadFunctions.getNewTexturedHead((String)mobName, (String)texture, (String)oldid, (String)headNoteBlockSound, (Integer)amount);
        texturedHeadStack.method_7977((class_2561)class_2561.method_43470((String)(formattedMobName + " Head")));
        return texturedHeadStack;
    }

    public static class_1799 getStandardHead(String headname) {
        String mob;
        class_1799 mobhead = new class_1799((class_1935)class_1802.field_8575, 1);
        switch (mob = headname.toLowerCase().split(" ")[0]) {
            case "creeper": {
                mobhead = new class_1799((class_1935)class_1802.field_8681, 1);
                break;
            }
            case "zombie": {
                mobhead = new class_1799((class_1935)class_1802.field_8470, 1);
                break;
            }
            case "skeleton": {
                mobhead = new class_1799((class_1935)class_1802.field_8398, 1);
            }
        }
        mobhead.method_7977((class_2561)class_2561.method_43470((String)headname));
        return mobhead;
    }

    public static String getName(class_1297 entity) {
        class_1641 zombievillager;
        class_3850 d;
        class_3852 prof;
        String entitystring = EntityFunctions.getEntityString((class_1297)entity);
        Object mobname = entitystring.split("\\[")[0].replace("Entity", "");
        mobname = String.join((CharSequence)"_", ((String)mobname).split("(?<=.)(?=\\p{Lu})")).toLowerCase();
        if (entity instanceof class_1548) {
            class_1548 creeper = (class_1548)entity;
            if (creeper.method_6872()) {
                mobname = "charged_creeper";
            }
        } else if (entity instanceof class_1451) {
            class_1451 cat = (class_1451)entity;
            class_7375 variant = cat.method_47843();
            class_2960 texture = variant.comp_706();
            String type = texture.toString().split("cat/")[1].replace(".png", "");
            mobname = type + "_cat";
        } else if (entity instanceof class_1498) {
            class_1498 horse = (class_1498)entity;
            int type = horse.method_27077().method_27082();
            if (type >= 1024) {
                type -= 1024;
            } else if (type >= 768) {
                type -= 768;
            } else if (type >= 512) {
                type -= 512;
            } else if (type >= 256) {
                type -= 256;
            }
            mobname = horsetypes.get(type) + "_horse";
        } else if (entity instanceof class_1501) {
            class_1501 llama = (class_1501)entity;
            int type = llama.method_6809().method_47875();
            if (type < llamatypes.size()) {
                mobname = llamatypes.get(type) + "_" + (String)mobname;
            }
        } else if (entity instanceof class_3986) {
            class_3986 traderllama = (class_3986)entity;
            int type = traderllama.method_6809().method_47875();
            if (type < llamatypes.size()) {
                mobname = llamatypes.get(type) + "_trader_" + (String)mobname;
            }
        } else if (entity instanceof class_1453) {
            class_1453 parrot = (class_1453)entity;
            int type = parrot.method_6584().method_47849();
            if (type < parrottypes.size()) {
                mobname = parrottypes.get(type) + "_parrot";
            }
        } else if (entity instanceof class_1463) {
            class_1463 rabbit = (class_1463)entity;
            int type = rabbit.method_47855().method_47856();
            String rabbitname = rabbit.method_5476().getString();
            if (rabbitname.equals("Toast")) {
                mobname = "toast_rabbit";
            } else if (type < rabbittypes.size()) {
                mobname = rabbittypes.get(type) + "_rabbit";
            } else if (type == 99) {
                mobname = "killer_rabbit";
            }
        } else if (entity instanceof class_1472) {
            String name;
            class_1472 sheep = (class_1472)entity;
            boolean checktype = true;
            if (sheep.method_16914() && (name = sheep.method_5477().getString()).equals("jeb_")) {
                mobname = "jeb_sheep";
                checktype = false;
            }
            if (checktype) {
                class_1767 type = sheep.method_6633();
                mobname = type.toString().toLowerCase() + "_sheep";
            }
        } else if (entity instanceof class_1438) {
            class_1438 mooshroom = (class_1438)entity;
            if (mooshroom.method_47847() == class_1438.class_4053.field_18110) {
                mobname = "brown_mooshroom";
            }
        } else if (entity instanceof class_4019) {
            class_4019 fox = (class_4019)entity;
            mobname = fox.method_47845() == class_4019.class_4039.field_17997 ? "snow_fox" : "red_fox";
        } else if (entity instanceof class_5762) {
            class_5762 axolotl = (class_5762)entity;
            int type = axolotl.method_33225().method_33233();
            if (type < axolotltypes.size()) {
                mobname = axolotltypes.get(type) + "_axolotl";
            }
        } else if (entity instanceof class_7102) {
            class_7102 frog = (class_7102)entity;
            class_7106 variant = frog.method_41354();
            if (variant.equals((Object)class_7106.field_37463)) {
                mobname = "warm_frog";
            } else if (variant.equals((Object)class_7106.field_37464)) {
                mobname = "cold_frog";
            } else if (variant.equals((Object)class_7106.field_37462)) {
                mobname = "temperate_frog";
            }
        } else if (entity instanceof class_1646) {
            class_1646 villager = (class_1646)entity;
            class_3850 d2 = villager.method_7231();
            class_3852 prof2 = d2.method_16924();
            if (!prof2.toString().equals("none")) {
                mobname = prof2.toString();
            }
        } else if (entity instanceof class_1641 && !(prof = (d = (zombievillager = (class_1641)entity).method_7231()).method_16924()).toString().equals("none")) {
            mobname = "zombie_" + prof;
        }
        return ((String)mobname).toLowerCase();
    }

    public static String capitalizeFirst(String string) {
        StringBuilder sb = new StringBuilder(string);
        for (int i = 0; i < sb.length(); ++i) {
            if (i != 0 && sb.charAt(i - 1) != ' ') continue;
            sb.setCharAt(i, Character.toUpperCase(sb.charAt(i)));
        }
        return sb.toString();
    }
}

