/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.justmobheads_common_fabric.events;

import com.mojang.authlib.GameProfile;
import com.natamus.collective_common_fabric.functions.StringFunctions;
import com.natamus.justmobheads_common_fabric.config.ConfigHandler;
import com.natamus.justmobheads_common_fabric.util.HeadData;
import com.natamus.justmobheads_common_fabric.util.MobHeads;
import java.util.UUID;
import joptsimple.internal.Strings;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1542;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1809;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2484;
import net.minecraft.class_2487;
import net.minecraft.class_2549;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2631;
import net.minecraft.class_2680;

public class HeadDropEvent {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void mobItemDrop(class_1937 world, class_1297 entity, class_1282 damageSource) {
        class_1542 mobhead;
        int looting;
        class_1321 te;
        if (world.field_9236) {
            return;
        }
        if (ConfigHandler.onlyDropHeadsByChargedCreeper || ConfigHandler.onlyDropHeadsByPlayerKill) {
            class_1297 sourceentity = damageSource.method_5526();
            if (ConfigHandler.onlyDropHeadsByChargedCreeper) {
                if (!(sourceentity instanceof class_1548)) return;
                class_1548 creeper = (class_1548)sourceentity;
                if (!creeper.method_6872()) {
                    return;
                }
            } else if (ConfigHandler.onlyDropHeadsByPlayerKill && !(sourceentity instanceof class_1657)) {
                return;
            }
        }
        if (ConfigHandler.onlyAdultMobsDropTheirHead && entity instanceof class_1321 && (te = (class_1321)entity).method_6109()) {
            return;
        }
        String mobname = MobHeads.getName(entity);
        if (mobname.equals("")) {
            return;
        }
        double extrachance = 0.0;
        class_1297 source = damageSource.method_5529();
        if (ConfigHandler.enableLootingEnchant && source instanceof class_1657 && (looting = class_1890.method_8226((class_1309)((class_1309)source))) > 0) {
            extrachance = 0.025 + (double)((float)looting / 100.0f);
        }
        Object headname = "";
        if (mobname.equals("creeper") || mobname.equals("zombie") || mobname.equals("skeleton")) {
            if (!ConfigHandler.enableStandardHeads) return;
            headname = mobname.substring(0, 1).toUpperCase() + mobname.substring(1) + " Head";
        }
        double num = Math.random();
        if (ConfigHandler.mobSpecificDropChances) {
            double chance = -1.0;
            if (((String)headname).equals("")) {
                if (HeadData.headChances.containsKey(mobname)) {
                    chance = HeadData.headChances.get(mobname);
                }
            } else {
                chance = ConfigHandler.creeperSkeletonZombieDropChance;
            }
            if (chance == -1.0 ? num > ConfigHandler.overallDropChance + extrachance : num > chance + extrachance) {
                return;
            }
        } else if (num > ConfigHandler.overallDropChance + extrachance) {
            return;
        }
        class_2338 pos = entity.method_24515();
        if (((String)headname).equals("")) {
            class_1799 headstack = MobHeads.getMobHead(mobname, 1);
            if (headstack == null) {
                return;
            }
            mobhead = new class_1542(world, (double)pos.method_10263(), (double)(pos.method_10264() + 1), (double)pos.method_10260(), headstack);
        } else {
            mobhead = new class_1542(world, (double)pos.method_10263(), (double)(pos.method_10264() + 1), (double)pos.method_10260(), MobHeads.getStandardHead((String)headname));
        }
        world.method_8649((class_1297)mobhead);
    }

    public static void onItemPickup(class_1937 level, class_1657 player, class_1799 itemStack) {
        class_2487 compoundTagSkullOwner;
        if (level.field_9236) {
            return;
        }
        class_1792 item = itemStack.method_7909();
        if (!(item instanceof class_1809)) {
            return;
        }
        String headName = "";
        class_2487 compoundTagItemStack = itemStack.method_7969();
        if (compoundTagItemStack == null) {
            return;
        }
        if (compoundTagItemStack.method_10573("SkullOwner", 8)) {
            headName = compoundTagItemStack.method_10558("SkullOwner");
        } else if (compoundTagItemStack.method_10573("SkullOwner", 10) && (compoundTagSkullOwner = compoundTagItemStack.method_10562("SkullOwner")).method_10573("Name", 8)) {
            headName = compoundTagSkullOwner.method_10558("Name");
        }
        if (headName.isEmpty()) {
            return;
        }
        String dataHeadName = headName.toLowerCase().replace(" ", "_");
        if (!HeadData.headTextureData.containsKey(dataHeadName)) {
            return;
        }
        if (!compoundTagItemStack.method_10545("note_block_sound") && HeadData.headNoteBlockSounds.containsKey(dataHeadName)) {
            compoundTagItemStack.method_10582("note_block_sound", HeadData.headNoteBlockSounds.get(dataHeadName));
        }
        itemStack.method_7977((class_2561)class_2561.method_43470((String)(StringFunctions.capitalizeEveryWord((String)headName.replace("_", " ")) + " Head")));
    }

    public static boolean onPlayerHeadBreak(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2586 blockEntity) {
        class_2248 block = state.method_26204();
        if (block instanceof class_2484 || block instanceof class_2549) {
            class_1799 named_headstack;
            class_2487 compoundTagSkullOwner;
            if (player.method_7337()) {
                return true;
            }
            class_2586 targetBlockEntity = world.method_8321(pos);
            if (!(targetBlockEntity instanceof class_2631)) {
                return true;
            }
            class_2631 sbe = (class_2631)targetBlockEntity;
            if (sbe == null) {
                return true;
            }
            String headName = "";
            class_2487 compoundTagItemStack = targetBlockEntity.method_16887();
            if (compoundTagItemStack.method_10573("SkullOwner", 8)) {
                headName = compoundTagItemStack.method_10558("SkullOwner");
            } else if (compoundTagItemStack.method_10573("SkullOwner", 10) && (compoundTagSkullOwner = compoundTagItemStack.method_10562("SkullOwner")).method_10573("Name", 8)) {
                headName = compoundTagSkullOwner.method_10558("Name");
            }
            if (!headName.isEmpty()) {
                return true;
            }
            GameProfile profile = sbe.method_11334();
            if (profile == null) {
                return true;
            }
            if (!Strings.isNullOrEmpty((String)profile.getName())) {
                return true;
            }
            UUID uuid = profile.getId();
            if (uuid == null) {
                return true;
            }
            String headid = uuid.toString();
            String correctheadname = "";
            for (String headname : HeadData.headTextureData.keySet()) {
                String headnameid = (String)HeadData.headTextureData.get(headname).getFirst();
                if (!headid.equals(headnameid)) continue;
                correctheadname = headname;
                break;
            }
            if ((named_headstack = MobHeads.getMobHead(correctheadname, 1)) != null) {
                world.method_22352(pos, false);
                world.method_8649((class_1297)new class_1542(world, (double)pos.method_10263(), (double)pos.method_10264() + 0.5, (double)pos.method_10260(), named_headstack));
                return false;
            }
        }
        return true;
    }
}

