/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.render.batch;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.rendering.BatchRenderElement;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.library.render.ItemStackRenderer;
import mezz.jei.library.render.batch.ElementWithModel;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;

public final class ItemStackBatchRenderer {
    private final List<ElementWithModel> useBlockLight = new ArrayList<ElementWithModel>();
    private final List<ElementWithModel> noBlockLight = new ArrayList<ElementWithModel>();
    private final List<BatchRenderElement<ItemStack>> customRender = new ArrayList<BatchRenderElement<ItemStack>>();

    public ItemStackBatchRenderer(Minecraft minecraft, List<BatchRenderElement<ItemStack>> elements) {
        ClientLevel level = minecraft.f_91073_;
        ItemRenderer itemRenderer = minecraft.m_91291_();
        for (BatchRenderElement<ItemStack> element : elements) {
            ElementWithModel elementWithModel;
            ItemStack itemStack = element.ingredient();
            if (itemStack.m_41619_()) continue;
            BakedModel bakedmodel = itemRenderer.m_174264_(itemStack, (Level)level, null, 0);
            if (bakedmodel.m_7521_()) {
                this.customRender.add(element);
                continue;
            }
            if (bakedmodel.m_7547_()) {
                elementWithModel = new ElementWithModel(bakedmodel, itemStack, element.x(), element.y());
                this.useBlockLight.add(elementWithModel);
                continue;
            }
            if (!bakedmodel.m_7539_()) {
                IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
                bakedmodel = renderHelper.createLimitedQuadItemModel(bakedmodel);
            }
            elementWithModel = new ElementWithModel(bakedmodel, itemStack, element.x(), element.y());
            this.noBlockLight.add(elementWithModel);
        }
    }

    public void render(GuiGraphics guiGraphics, Minecraft minecraft, ItemRenderer itemRenderer, ItemStackRenderer itemStackRenderer) {
        Font font;
        ItemStack ingredient;
        if (!this.noBlockLight.isEmpty()) {
            Lighting.m_84930_();
            for (ElementWithModel element : this.noBlockLight) {
                this.renderItem(guiGraphics, itemRenderer, element.model(), element.stack(), element.x(), element.y());
            }
            guiGraphics.m_280262_();
            Lighting.m_84931_();
        }
        if (!this.useBlockLight.isEmpty()) {
            for (ElementWithModel element : this.useBlockLight) {
                this.renderItem(guiGraphics, itemRenderer, element.model(), element.stack(), element.x(), element.y());
            }
            guiGraphics.m_280262_();
        }
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        for (ElementWithModel elementWithModel : this.useBlockLight) {
            ingredient = elementWithModel.stack();
            font = renderHelper.getFontRenderer(minecraft, ingredient);
            guiGraphics.m_280370_(font, ingredient, elementWithModel.x(), elementWithModel.y());
        }
        for (ElementWithModel elementWithModel : this.noBlockLight) {
            ingredient = elementWithModel.stack();
            font = renderHelper.getFontRenderer(minecraft, ingredient);
            guiGraphics.m_280370_(font, ingredient, elementWithModel.x(), elementWithModel.y());
        }
        RenderSystem.disableBlend();
        for (BatchRenderElement batchRenderElement : this.customRender) {
            ingredient = (ItemStack)batchRenderElement.ingredient();
            itemStackRenderer.render(guiGraphics, ingredient, batchRenderElement.x(), batchRenderElement.y());
            RenderSystem.disableBlend();
        }
        RenderSystem.disableBlend();
    }

    private void renderItem(GuiGraphics guiGraphics, ItemRenderer itemRenderer, BakedModel bakedmodel, ItemStack itemStack, int x, int y) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)(x + 8), (float)(y + 8), 150.0f);
        poseStack.m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        poseStack.m_85841_(16.0f, 16.0f, 16.0f);
        try {
            itemRenderer.m_115143_(itemStack, ItemDisplayContext.GUI, false, poseStack, (MultiBufferSource)guiGraphics.m_280091_(), 0xF000F0, OverlayTexture.f_118083_, bakedmodel);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Rendering item");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Item being rendered");
            crashreportcategory.m_128165_("Item Type", () -> String.valueOf(itemStack.m_41720_()));
            crashreportcategory.m_128165_("Item NBT", () -> String.valueOf(itemStack.m_41783_()));
            crashreportcategory.m_128165_("Item Foil", () -> String.valueOf(itemStack.m_41790_()));
            throw new ReportedException(crashreport);
        }
        poseStack.m_85849_();
    }
}

