/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.bluenbt.adapter;

import com.google.gson.reflect.TypeToken;
import de.bluecolored.shadow.bluenbt.BlueNBT;
import de.bluecolored.shadow.bluenbt.NBTWriter;
import de.bluecolored.shadow.bluenbt.TagType;
import de.bluecolored.shadow.bluenbt.TypeSerializer;
import de.bluecolored.shadow.bluenbt.TypeSerializerFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class PrimitiveSerializerFactory
implements TypeSerializerFactory {
    public static final PrimitiveSerializerFactory INSTANCE = new PrimitiveSerializerFactory();
    private static final Map<Type, TypeSerializer<?>> TYPE_SERIALIZER_MAP = new HashMap();

    private static <T> void registerTypeSerializer(Type primitiveType, Type boxedType, final TagType tag, final TypeSerializer<T> typeSerializer) {
        TypeSerializer tagTypeTypeSerializer = new TypeSerializer<T>(){

            @Override
            public void write(T value, NBTWriter writer) throws IOException {
                typeSerializer.write(value, writer);
            }

            @Override
            public TagType type() {
                return tag;
            }
        };
        TYPE_SERIALIZER_MAP.put(primitiveType, tagTypeTypeSerializer);
        if (boxedType != null) {
            TYPE_SERIALIZER_MAP.put(boxedType, tagTypeTypeSerializer);
        }
    }

    public <T> Optional<TypeSerializer<T>> create(TypeToken<T> typeToken, BlueNBT blueNBT) {
        TypeSerializer<?> typeSerializer = TYPE_SERIALIZER_MAP.get(typeToken.getRawType());
        if (typeSerializer != null) {
            return Optional.of(typeSerializer);
        }
        return Optional.empty();
    }

    public static void writeBool(boolean value, NBTWriter writer) throws IOException {
        writer.value(value ? (byte)1 : 0);
    }

    public static void writeByte(byte value, NBTWriter writer) throws IOException {
        writer.value(value);
    }

    public static void writeShort(short value, NBTWriter writer) throws IOException {
        writer.value(value);
    }

    public static void writeChar(char value, NBTWriter writer) throws IOException {
        writer.value(value);
    }

    public static void writeInt(int value, NBTWriter writer) throws IOException {
        writer.value(value);
    }

    public static void writeLong(long value, NBTWriter writer) throws IOException {
        writer.value(value);
    }

    public static void writeFloat(float value, NBTWriter writer) throws IOException {
        writer.value(value);
    }

    public static void writeDouble(double value, NBTWriter writer) throws IOException {
        writer.value(value);
    }

    public static void writeString(String value, NBTWriter writer) throws IOException {
        writer.value(value);
    }

    static {
        PrimitiveSerializerFactory.registerTypeSerializer(Boolean.TYPE, Boolean.class, TagType.BYTE, PrimitiveSerializerFactory::writeBool);
        PrimitiveSerializerFactory.registerTypeSerializer(Byte.TYPE, Byte.class, TagType.BYTE, PrimitiveSerializerFactory::writeByte);
        PrimitiveSerializerFactory.registerTypeSerializer(Short.TYPE, Short.class, TagType.SHORT, PrimitiveSerializerFactory::writeShort);
        PrimitiveSerializerFactory.registerTypeSerializer(Character.TYPE, Character.class, TagType.SHORT, PrimitiveSerializerFactory::writeChar);
        PrimitiveSerializerFactory.registerTypeSerializer(Integer.TYPE, Integer.class, TagType.INT, PrimitiveSerializerFactory::writeInt);
        PrimitiveSerializerFactory.registerTypeSerializer(Long.TYPE, Long.class, TagType.LONG, PrimitiveSerializerFactory::writeLong);
        PrimitiveSerializerFactory.registerTypeSerializer(Float.TYPE, Float.class, TagType.FLOAT, PrimitiveSerializerFactory::writeFloat);
        PrimitiveSerializerFactory.registerTypeSerializer(Double.TYPE, Double.class, TagType.DOUBLE, PrimitiveSerializerFactory::writeDouble);
        PrimitiveSerializerFactory.registerTypeSerializer(String.class, null, TagType.STRING, PrimitiveSerializerFactory::writeString);
    }
}

