/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.bluenbt.adapter;

import com.google.gson.reflect.TypeToken;
import de.bluecolored.shadow.bluenbt.BlueNBT;
import de.bluecolored.shadow.bluenbt.NBTReader;
import de.bluecolored.shadow.bluenbt.TagType;
import de.bluecolored.shadow.bluenbt.TypeDeserializer;
import de.bluecolored.shadow.bluenbt.TypeDeserializerFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class PrimitiveDeserializerFactory
implements TypeDeserializerFactory {
    public static final PrimitiveDeserializerFactory INSTANCE = new PrimitiveDeserializerFactory();
    private static final Map<Type, TypeDeserializer<?>> TYPE_DESERIALIZER_MAP = new HashMap();

    private static void registerTypeDeserializer(Type primitiveType, Type boxedType, TypeDeserializer<?> typeDeserializer) {
        TYPE_DESERIALIZER_MAP.put(primitiveType, typeDeserializer);
        if (boxedType != null) {
            TYPE_DESERIALIZER_MAP.put(boxedType, typeDeserializer);
        }
    }

    public <T> Optional<TypeDeserializer<T>> create(TypeToken<T> typeToken, BlueNBT blueNBT) {
        TypeDeserializer<?> typeDeserializer = TYPE_DESERIALIZER_MAP.get(typeToken.getRawType());
        if (typeDeserializer != null) {
            return Optional.of(typeDeserializer);
        }
        return Optional.empty();
    }

    public static boolean readBool(NBTReader reader) throws IOException {
        TagType type = reader.peek();
        switch (type) {
            case BYTE: {
                return reader.nextByte() != 0;
            }
            case SHORT: {
                return reader.nextShort() != 0;
            }
            case INT: {
                return reader.nextInt() != 0;
            }
            case LONG: {
                return reader.nextLong() != 0L;
            }
            case FLOAT: {
                return reader.nextFloat() != 0.0f;
            }
            case DOUBLE: {
                return reader.nextDouble() != 0.0;
            }
            case STRING: {
                return Boolean.parseBoolean(reader.nextString());
            }
        }
        throw new IllegalStateException("STRING or any number tag expected but got " + type + ". At: " + reader.path());
    }

    public static byte readByte(NBTReader reader) throws IOException {
        TagType type = reader.peek();
        switch (type) {
            case BYTE: {
                return reader.nextByte();
            }
            case SHORT: {
                return (byte)reader.nextShort();
            }
            case INT: {
                return (byte)reader.nextInt();
            }
            case LONG: {
                return (byte)reader.nextLong();
            }
            case FLOAT: {
                return (byte)reader.nextFloat();
            }
            case DOUBLE: {
                return (byte)reader.nextDouble();
            }
            case STRING: {
                return Byte.parseByte(reader.nextString());
            }
        }
        throw new IllegalStateException("BYTE tag expected but got " + type + ". At: " + reader.path());
    }

    public static short readShort(NBTReader reader) throws IOException {
        TagType type = reader.peek();
        switch (type) {
            case BYTE: {
                return reader.nextByte();
            }
            case SHORT: {
                return reader.nextShort();
            }
            case INT: {
                return (short)reader.nextInt();
            }
            case LONG: {
                return (short)reader.nextLong();
            }
            case FLOAT: {
                return (short)reader.nextFloat();
            }
            case DOUBLE: {
                return (short)reader.nextDouble();
            }
            case STRING: {
                return Short.parseShort(reader.nextString());
            }
        }
        throw new IllegalStateException("SHORT tag expected but got " + type + ". At: " + reader.path());
    }

    public static char readChar(NBTReader reader) throws IOException {
        TagType type = reader.peek();
        switch (type) {
            case BYTE: {
                return (char)reader.nextByte();
            }
            case SHORT: {
                return (char)reader.nextShort();
            }
            case INT: {
                return (char)reader.nextInt();
            }
            case LONG: {
                return (char)reader.nextLong();
            }
            case FLOAT: {
                return (char)reader.nextFloat();
            }
            case DOUBLE: {
                return (char)reader.nextDouble();
            }
            case STRING: {
                String string = reader.nextString();
                if (string.length() != 1) {
                    throw new IllegalStateException("Can not parse char from string '" + string + "'");
                }
                return string.charAt(0);
            }
        }
        throw new IllegalStateException("Any number tag expected but got " + type + ". At: " + reader.path());
    }

    public static int readInt(NBTReader reader) throws IOException {
        TagType type = reader.peek();
        switch (type) {
            case BYTE: {
                return reader.nextByte();
            }
            case SHORT: {
                return reader.nextShort();
            }
            case INT: {
                return reader.nextInt();
            }
            case LONG: {
                return (int)reader.nextLong();
            }
            case FLOAT: {
                return (int)reader.nextFloat();
            }
            case DOUBLE: {
                return (int)reader.nextDouble();
            }
            case STRING: {
                return Integer.parseInt(reader.nextString());
            }
        }
        throw new IllegalStateException("INT tag expected but got " + type + ". At: " + reader.path());
    }

    public static long readLong(NBTReader reader) throws IOException {
        TagType type = reader.peek();
        switch (type) {
            case LONG: {
                return reader.nextLong();
            }
            case BYTE: {
                return reader.nextByte();
            }
            case SHORT: {
                return reader.nextShort();
            }
            case INT: {
                return reader.nextInt();
            }
            case FLOAT: {
                return (long)reader.nextFloat();
            }
            case DOUBLE: {
                return (long)reader.nextDouble();
            }
            case STRING: {
                return Long.parseLong(reader.nextString());
            }
        }
        throw new IllegalStateException("LONG tag expected but got " + type + ". At: " + reader.path());
    }

    public static float readFloat(NBTReader reader) throws IOException {
        TagType type = reader.peek();
        switch (type) {
            case FLOAT: {
                return reader.nextFloat();
            }
            case BYTE: {
                return reader.nextByte();
            }
            case SHORT: {
                return reader.nextShort();
            }
            case INT: {
                return reader.nextInt();
            }
            case LONG: {
                return reader.nextLong();
            }
            case DOUBLE: {
                return (float)reader.nextDouble();
            }
            case STRING: {
                return Float.parseFloat(reader.nextString());
            }
        }
        throw new IllegalStateException("FLOAT tag expected but got " + type + ". At: " + reader.path());
    }

    public static double readDouble(NBTReader reader) throws IOException {
        TagType type = reader.peek();
        switch (type) {
            case DOUBLE: {
                return reader.nextDouble();
            }
            case BYTE: {
                return reader.nextByte();
            }
            case SHORT: {
                return reader.nextShort();
            }
            case INT: {
                return reader.nextInt();
            }
            case LONG: {
                return reader.nextLong();
            }
            case FLOAT: {
                return reader.nextFloat();
            }
            case STRING: {
                return Double.parseDouble(reader.nextString());
            }
        }
        throw new IllegalStateException("DOUBLE tag expected but got " + type + ". At: " + reader.path());
    }

    public static String readString(NBTReader reader) throws IOException {
        TagType type = reader.peek();
        switch (type) {
            case STRING: {
                return reader.nextString();
            }
            case BYTE: {
                return String.valueOf(reader.nextByte());
            }
            case SHORT: {
                return String.valueOf(reader.nextShort());
            }
            case INT: {
                return String.valueOf(reader.nextInt());
            }
            case LONG: {
                return String.valueOf(reader.nextLong());
            }
            case FLOAT: {
                return String.valueOf(reader.nextFloat());
            }
            case DOUBLE: {
                return String.valueOf(reader.nextDouble());
            }
        }
        throw new IllegalStateException("STRING tag expected but got " + type + ". At: " + reader.path());
    }

    static {
        PrimitiveDeserializerFactory.registerTypeDeserializer(Boolean.TYPE, Boolean.class, PrimitiveDeserializerFactory::readBool);
        PrimitiveDeserializerFactory.registerTypeDeserializer(Byte.TYPE, Byte.class, PrimitiveDeserializerFactory::readByte);
        PrimitiveDeserializerFactory.registerTypeDeserializer(Short.TYPE, Short.class, PrimitiveDeserializerFactory::readShort);
        PrimitiveDeserializerFactory.registerTypeDeserializer(Character.TYPE, Character.class, PrimitiveDeserializerFactory::readChar);
        PrimitiveDeserializerFactory.registerTypeDeserializer(Integer.TYPE, Integer.class, PrimitiveDeserializerFactory::readInt);
        PrimitiveDeserializerFactory.registerTypeDeserializer(Long.TYPE, Long.class, PrimitiveDeserializerFactory::readLong);
        PrimitiveDeserializerFactory.registerTypeDeserializer(Float.TYPE, Float.class, PrimitiveDeserializerFactory::readFloat);
        PrimitiveDeserializerFactory.registerTypeDeserializer(Double.TYPE, Double.class, PrimitiveDeserializerFactory::readDouble);
        PrimitiveDeserializerFactory.registerTypeDeserializer(String.class, null, PrimitiveDeserializerFactory::readString);
    }
}

