/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.bluenbt.adapter;

import com.google.gson.reflect.TypeToken;
import de.bluecolored.shadow.bluenbt.BlueNBT;
import de.bluecolored.shadow.bluenbt.NBTAdapter;
import de.bluecolored.shadow.bluenbt.NBTName;
import de.bluecolored.shadow.bluenbt.NBTSerializer;
import de.bluecolored.shadow.bluenbt.NBTWriter;
import de.bluecolored.shadow.bluenbt.TypeSerializer;
import de.bluecolored.shadow.bluenbt.TypeSerializerFactory;
import de.bluecolored.shadow.bluenbt.adapter.TypeUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class DefaultSerializerFactory
implements TypeSerializerFactory {
    public static final DefaultSerializerFactory INSTANCE = new DefaultSerializerFactory();

    public <T> Optional<TypeSerializer<T>> create(TypeToken<T> type, BlueNBT blueNBT) {
        return Optional.of(this.createFor(type, blueNBT));
    }

    public <T> TypeSerializer<T> createFor(TypeToken<T> type, BlueNBT blueNBT) {
        return new DefaultAdapter<T>(type, blueNBT);
    }

    private static class TypeSerializerFieldWriter<T>
    implements FieldWriter {
        private final Field field;
        private final TypeSerializer<T> typeSerializer;

        @Override
        public void write(String name, Object object, NBTWriter writer) throws IOException, IllegalAccessException {
            Object value = this.field.get(object);
            if (value != null) {
                writer.name(name);
                this.typeSerializer.write(value, writer);
            }
        }

        public TypeSerializerFieldWriter(Field field, TypeSerializer<T> typeSerializer) {
            this.field = field;
            this.typeSerializer = typeSerializer;
        }
    }

    private static interface SpecialFieldWriter
    extends FieldWriter {
        @Override
        default public void write(String name, Object object, NBTWriter writer) throws IOException, IllegalAccessException {
            writer.name(name);
            this.writeValue(object, writer);
        }

        public void writeValue(Object var1, NBTWriter var2) throws IOException, IllegalAccessException;
    }

    private static interface FieldWriter {
        public void write(String var1, Object var2, NBTWriter var3) throws IOException, IllegalAccessException;
    }

    static class DefaultAdapter<T>
    implements TypeSerializer<T> {
        private static final Map<Type, Function<Field, SpecialFieldWriter>> SPECIAL_ACCESSORS = Map.of(Boolean.TYPE, field -> (object, writer) -> writer.value(field.getBoolean(object) ? (byte)1 : (byte)0), Byte.TYPE, field -> (object, writer) -> writer.value(field.getByte(object)), Short.TYPE, field -> (object, writer) -> writer.value(field.getShort(object)), Character.TYPE, field -> (object, writer) -> writer.value(field.getChar(object)), Integer.TYPE, field -> (object, writer) -> writer.value(field.getInt(object)), Long.TYPE, field -> (object, writer) -> writer.value(field.getLong(object)), Float.TYPE, field -> (object, writer) -> writer.value(field.getFloat(object)), Double.TYPE, field -> (object, writer) -> writer.value(field.getDouble(object)));
        private final TypeToken<T> type;
        private final Map<String, FieldWriter> fields = new HashMap<String, FieldWriter>();

        public DefaultAdapter(TypeToken<T> type, BlueNBT blueNBT) {
            Class raw;
            this.type = type;
            HashMap<Class, TypeSerializer> typeSerializerCache = new HashMap<Class, TypeSerializer>();
            TypeToken typeToken = type;
            while (typeToken != null && (raw = typeToken.getRawType()) != Object.class) {
                for (Field field : raw.getDeclaredFields()) {
                    FieldWriter accessor;
                    TypeSerializer typeSerializer;
                    TypeToken fieldType;
                    Class<TypeSerializer<?>> serializerType;
                    int modifiers = field.getModifiers();
                    if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                    field.setAccessible(true);
                    String[] names = new String[]{field.getName()};
                    NBTName nbtName = field.getAnnotation(NBTName.class);
                    if (nbtName != null) {
                        names = nbtName.value();
                    }
                    if ((serializerType = this.findSerializerType(field, (fieldType = TypeToken.get((Type)TypeUtil.resolve(typeToken.getType(), raw, field.getGenericType()))).getRawType())) != null) {
                        typeSerializer = typeSerializerCache.computeIfAbsent(serializerType, t2 -> {
                            try {
                                try {
                                    return (TypeSerializer)t2.getDeclaredConstructor(BlueNBT.class).newInstance(blueNBT);
                                }
                                catch (NoSuchMethodException noSuchMethodException) {
                                    return (TypeSerializer)t2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                                }
                            }
                            catch (Exception ex) {
                                throw new RuntimeException("Failed to create Instance of TypeSerializer!", ex);
                            }
                        });
                    } else {
                        if (SPECIAL_ACCESSORS.containsKey(fieldType.getType())) {
                            accessor = SPECIAL_ACCESSORS.get(fieldType.getType()).apply(field);
                            for (String name : names) {
                                this.fields.put(name, accessor);
                            }
                            continue;
                        }
                        typeSerializer = blueNBT.getTypeSerializer(fieldType);
                    }
                    accessor = new TypeSerializerFieldWriter(field, typeSerializer);
                    for (String name : names) {
                        this.fields.put(name, accessor);
                    }
                }
                Type superType = TypeUtil.resolve(typeToken.getType(), raw, raw.getGenericSuperclass());
                typeToken = superType != null ? TypeToken.get((Type)superType) : null;
            }
        }

        @Override
        public void write(T value, NBTWriter writer) throws IOException {
            try {
                writer.beginCompound();
                for (Map.Entry<String, FieldWriter> field : this.fields.entrySet()) {
                    field.getValue().write(field.getKey(), value, writer);
                }
                writer.endCompound();
            }
            catch (IllegalAccessException ex) {
                throw new IOException("Failed to create instance of type '" + this.type + "'!", ex);
            }
        }

        @Nullable
        private Class<? extends TypeSerializer<?>> findSerializerType(Field field, Class<?> type) {
            NBTSerializer fieldSerializer = field.getAnnotation(NBTSerializer.class);
            if (fieldSerializer != null) {
                return fieldSerializer.value();
            }
            NBTAdapter fieldAdapter = field.getAnnotation(NBTAdapter.class);
            if (fieldAdapter != null) {
                return fieldAdapter.value();
            }
            NBTSerializer typeSerializer = type.getAnnotation(NBTSerializer.class);
            if (typeSerializer != null) {
                return typeSerializer.value();
            }
            NBTAdapter typeAdapter = type.getAnnotation(NBTAdapter.class);
            if (typeAdapter != null) {
                return typeAdapter.value();
            }
            return null;
        }
    }
}

