/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.bluenbt.adapter;

import com.google.gson.reflect.TypeToken;
import de.bluecolored.shadow.bluenbt.BlueNBT;
import de.bluecolored.shadow.bluenbt.NBTAdapter;
import de.bluecolored.shadow.bluenbt.NBTDeserializer;
import de.bluecolored.shadow.bluenbt.NBTName;
import de.bluecolored.shadow.bluenbt.NBTPostDeserialize;
import de.bluecolored.shadow.bluenbt.NBTReader;
import de.bluecolored.shadow.bluenbt.ObjectConstructor;
import de.bluecolored.shadow.bluenbt.TagType;
import de.bluecolored.shadow.bluenbt.TypeDeserializer;
import de.bluecolored.shadow.bluenbt.TypeDeserializerFactory;
import de.bluecolored.shadow.bluenbt.adapter.PrimitiveDeserializerFactory;
import de.bluecolored.shadow.bluenbt.adapter.TypeUtil;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class DefaultDeserializerFactory
implements TypeDeserializerFactory {
    public static final DefaultDeserializerFactory INSTANCE = new DefaultDeserializerFactory();

    public <T> Optional<TypeDeserializer<T>> create(TypeToken<T> type, BlueNBT blueNBT) {
        return Optional.of(this.createFor(type, blueNBT));
    }

    public <T> TypeDeserializer<T> createFor(TypeToken<T> type, BlueNBT blueNBT) {
        try {
            return new DefaultAdapter<T>(type, blueNBT.createObjectConstructor(type), blueNBT);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to create Default-TypeSerializer for type: " + type, ex);
        }
    }

    private static class TypeDeserializerFieldAccessor
    implements FieldAccessor {
        private final Field field;
        private final TypeDeserializer<?> typeDeserializer;

        @Override
        public void read(Object object, NBTReader reader) throws IOException, IllegalAccessException {
            this.field.set(object, this.typeDeserializer.read(reader));
        }

        public TypeDeserializerFieldAccessor(Field field, TypeDeserializer<?> typeDeserializer) {
            this.field = field;
            this.typeDeserializer = typeDeserializer;
        }
    }

    @FunctionalInterface
    private static interface PostSerializeAction<T> {
        public void invoke(T var1) throws IOException, IllegalAccessException, InvocationTargetException;
    }

    @FunctionalInterface
    private static interface FieldAccessor {
        public void read(Object var1, NBTReader var2) throws IOException, IllegalAccessException;
    }

    static class DefaultAdapter<T>
    implements TypeDeserializer<T> {
        private static final Map<Type, Function<Field, FieldAccessor>> SPECIAL_ACCESSORS = Map.of(Boolean.TYPE, field -> (object, reader) -> field.setBoolean(object, PrimitiveDeserializerFactory.readBool(reader)), Byte.TYPE, field -> (object, reader) -> field.setByte(object, PrimitiveDeserializerFactory.readByte(reader)), Short.TYPE, field -> (object, reader) -> field.setShort(object, PrimitiveDeserializerFactory.readShort(reader)), Character.TYPE, field -> (object, reader) -> field.setChar(object, PrimitiveDeserializerFactory.readChar(reader)), Integer.TYPE, field -> (object, reader) -> field.setInt(object, PrimitiveDeserializerFactory.readInt(reader)), Long.TYPE, field -> (object, reader) -> field.setLong(object, PrimitiveDeserializerFactory.readLong(reader)), Float.TYPE, field -> (object, reader) -> field.setFloat(object, PrimitiveDeserializerFactory.readFloat(reader)), Double.TYPE, field -> (object, reader) -> field.setDouble(object, PrimitiveDeserializerFactory.readDouble(reader)));
        private final TypeToken<T> type;
        private final ObjectConstructor<T> constructor;
        private final BlueNBT blueNBT;
        private final Map<String, FieldAccessor> fields = new HashMap<String, FieldAccessor>();
        private final Collection<PostSerializeAction<T>> postSerializeActions = new ArrayList<PostSerializeAction<T>>(0);

        public DefaultAdapter(TypeToken<T> type, ObjectConstructor<T> constructor, BlueNBT blueNBT) {
            Class raw;
            this.type = type;
            this.constructor = constructor;
            this.blueNBT = blueNBT;
            HashMap<Class, TypeDeserializer> typeDeserializerCache = new HashMap<Class, TypeDeserializer>();
            TypeToken typeToken = type;
            while (typeToken != null && (raw = typeToken.getRawType()) != Object.class) {
                for (Field field : raw.getDeclaredFields()) {
                    FieldAccessor accessor;
                    TypeDeserializer<Object> typeDeserializer;
                    TypeToken fieldType;
                    Class<TypeDeserializer<?>> deserializerType;
                    int modifiers = field.getModifiers();
                    if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                    field.setAccessible(true);
                    String[] names = new String[]{field.getName()};
                    NBTName nbtName = field.getAnnotation(NBTName.class);
                    if (nbtName != null) {
                        names = nbtName.value();
                    }
                    if ((deserializerType = this.findDeserializerType(field, (fieldType = TypeToken.get((Type)TypeUtil.resolve(typeToken.getType(), raw, field.getGenericType()))).getRawType())) != null) {
                        typeDeserializer = typeDeserializerCache.computeIfAbsent(deserializerType, t2 -> {
                            try {
                                try {
                                    return (TypeDeserializer)t2.getDeclaredConstructor(BlueNBT.class).newInstance(blueNBT);
                                }
                                catch (NoSuchMethodException noSuchMethodException) {
                                    return (TypeDeserializer)t2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                                }
                            }
                            catch (Exception ex) {
                                throw new RuntimeException("Failed to create Instance of TypeDeserializer!", ex);
                            }
                        });
                    } else {
                        if (SPECIAL_ACCESSORS.containsKey(fieldType.getType())) {
                            accessor = SPECIAL_ACCESSORS.get(fieldType.getType()).apply(field);
                            for (String name : names) {
                                this.fields.put(name, accessor);
                            }
                            continue;
                        }
                        typeDeserializer = reader -> blueNBT.read(reader, fieldType);
                    }
                    accessor = new TypeDeserializerFieldAccessor(field, typeDeserializer);
                    for (String name : names) {
                        this.fields.put(name, accessor);
                    }
                }
                for (AccessibleObject accessibleObject : raw.getDeclaredMethods()) {
                    if (((Method)accessibleObject).getAnnotation(NBTPostDeserialize.class) == null || ((Method)accessibleObject).getParameterCount() != 0) continue;
                    ((Method)accessibleObject).setAccessible(true);
                    this.postSerializeActions.add(arg_0 -> DefaultAdapter.lambda$new$18((Method)accessibleObject, arg_0));
                }
                Type superType = TypeUtil.resolve(typeToken.getType(), raw, raw.getGenericSuperclass());
                typeToken = superType != null ? TypeToken.get((Type)superType) : null;
            }
        }

        @Override
        public T read(NBTReader reader) throws IOException {
            try {
                T object = this.constructor.construct();
                reader.beginCompound();
                while (reader.peek() != TagType.END) {
                    String name = reader.name();
                    FieldAccessor fieldInfo = this.fields.get(name);
                    if (fieldInfo == null) {
                        name = (String)this.blueNBT.getFieldNameTransformer().apply(name);
                        fieldInfo = this.fields.get(name);
                    }
                    if (fieldInfo != null) {
                        fieldInfo.read(object, reader);
                        continue;
                    }
                    reader.skip();
                }
                reader.endCompound();
                if (!this.postSerializeActions.isEmpty()) {
                    for (PostSerializeAction<T> action : this.postSerializeActions) {
                        action.invoke(object);
                    }
                }
                return object;
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new IOException("Failed to create instance of type '" + this.type + "'!", ex);
            }
        }

        @Nullable
        private Class<? extends TypeDeserializer<?>> findDeserializerType(Field field, Class<?> type) {
            NBTDeserializer fieldDeserializer = field.getAnnotation(NBTDeserializer.class);
            if (fieldDeserializer != null) {
                return fieldDeserializer.value();
            }
            NBTAdapter fieldAdapter = field.getAnnotation(NBTAdapter.class);
            if (fieldAdapter != null) {
                return fieldAdapter.value();
            }
            NBTDeserializer typeDeserializer = type.getAnnotation(NBTDeserializer.class);
            if (typeDeserializer != null) {
                return typeDeserializer.value();
            }
            NBTAdapter typeAdapter = type.getAnnotation(NBTAdapter.class);
            if (typeAdapter != null) {
                return typeAdapter.value();
            }
            return null;
        }

        private static /* synthetic */ void lambda$new$18(Method rec$, Object x$0) throws IOException, IllegalAccessException, InvocationTargetException {
            rec$.invoke(x$0, new Object[0]);
        }
    }
}

