/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.bluenbt.adapter;

import com.google.gson.reflect.TypeToken;
import de.bluecolored.shadow.bluenbt.BlueNBT;
import de.bluecolored.shadow.bluenbt.NBTReader;
import de.bluecolored.shadow.bluenbt.NBTWriter;
import de.bluecolored.shadow.bluenbt.ObjectConstructor;
import de.bluecolored.shadow.bluenbt.TagType;
import de.bluecolored.shadow.bluenbt.TypeAdapter;
import de.bluecolored.shadow.bluenbt.TypeAdapterFactory;
import de.bluecolored.shadow.bluenbt.TypeDeserializer;
import de.bluecolored.shadow.bluenbt.TypeSerializer;
import de.bluecolored.shadow.bluenbt.adapter.TypeUtil;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

public class CollectionAdapterFactory
implements TypeAdapterFactory {
    public static final CollectionAdapterFactory INSTANCE = new CollectionAdapterFactory();

    public <T> Optional<TypeAdapter<T>> create(TypeToken<T> typeToken, BlueNBT blueNBT) {
        Type type = typeToken.getType();
        Class rawType = typeToken.getRawType();
        if (!Collection.class.isAssignableFrom(rawType)) {
            return Optional.empty();
        }
        Type elementType = TypeUtil.getCollectionElementType(type, rawType);
        TypeSerializer elementTypeSerializer = blueNBT.getTypeSerializer(TypeToken.get((Type)elementType));
        TypeDeserializer elementTypeDeserializer = blueNBT.getTypeDeserializer(TypeToken.get((Type)elementType));
        ObjectConstructor<T> constructor = blueNBT.createObjectConstructor(typeToken);
        CollectionAdapter result = new CollectionAdapter(elementTypeSerializer, elementTypeDeserializer, constructor);
        return Optional.of(result);
    }

    static class CollectionAdapter<E>
    implements TypeAdapter<Collection<E>> {
        private final TypeSerializer<E> typeSerializer;
        private final TypeDeserializer<E> typeDeserializer;
        private final ObjectConstructor<? extends Collection<E>> constructor;

        @Override
        public Collection<E> read(NBTReader reader) throws IOException {
            Collection<E> collection = this.constructor.construct();
            reader.beginList();
            while (reader.hasNext()) {
                E instance = this.typeDeserializer.read(reader);
                collection.add(instance);
            }
            reader.endList();
            return collection;
        }

        @Override
        public void write(Collection<E> value, NBTWriter writer) throws IOException {
            int size = value.size();
            if (size == 0) {
                writer.beginList(size, this.typeSerializer.type());
                writer.endList();
            } else {
                writer.beginList(size);
                for (E element : value) {
                    this.typeSerializer.write(Objects.requireNonNull(element, "'null' values are not supported in a list."), writer);
                }
                writer.endList();
            }
        }

        @Override
        public TagType type() {
            return TagType.LIST;
        }

        public CollectionAdapter(TypeSerializer<E> typeSerializer, TypeDeserializer<E> typeDeserializer, ObjectConstructor<? extends Collection<E>> constructor) {
            this.typeSerializer = typeSerializer;
            this.typeDeserializer = typeDeserializer;
            this.constructor = constructor;
        }
    }
}

