/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.bluenbt.adapter;

import com.google.gson.reflect.TypeToken;
import de.bluecolored.shadow.bluenbt.BlueNBT;
import de.bluecolored.shadow.bluenbt.NBTReader;
import de.bluecolored.shadow.bluenbt.NBTWriter;
import de.bluecolored.shadow.bluenbt.TagType;
import de.bluecolored.shadow.bluenbt.TypeAdapter;
import de.bluecolored.shadow.bluenbt.TypeAdapterFactory;
import de.bluecolored.shadow.bluenbt.TypeDeserializer;
import de.bluecolored.shadow.bluenbt.TypeSerializer;
import de.bluecolored.shadow.bluenbt.adapter.TypeUtil;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;

public class ArrayAdapterFactory
implements TypeAdapterFactory {
    public static final ArrayAdapterFactory INSTANCE = new ArrayAdapterFactory();

    public <T> Optional<TypeAdapter<T>> create(TypeToken<T> typeToken, BlueNBT blueNBT) {
        Type type = typeToken.getType();
        if (!(type instanceof GenericArrayType || type instanceof Class && ((Class)type).isArray())) {
            return Optional.empty();
        }
        Type componentType = TypeUtil.getArrayComponentType(type);
        TypeSerializer componentTypeSerializer = blueNBT.getTypeSerializer(TypeToken.get((Type)componentType));
        TypeDeserializer componentTypeDeserializer = blueNBT.getTypeDeserializer(TypeToken.get((Type)componentType));
        ArrayAdapter result = new ArrayAdapter(TypeUtil.getRawType(componentType), componentTypeSerializer, componentTypeDeserializer);
        return Optional.of(result);
    }

    static class ArrayAdapter<E>
    implements TypeAdapter<Object> {
        private final Class<E> type;
        private final TypeSerializer<E> typeSerializer;
        private final TypeDeserializer<E> typeDeserializer;

        @Override
        public Object read(NBTReader reader) throws IOException {
            TagType tag = reader.peek();
            if (tag == TagType.BYTE_ARRAY && this.type.equals(Byte.TYPE)) {
                return reader.nextByteArray();
            }
            if (tag == TagType.INT_ARRAY && this.type.equals(Integer.TYPE)) {
                return reader.nextIntArray();
            }
            if (tag == TagType.LONG_ARRAY && this.type.equals(Long.TYPE)) {
                return reader.nextLongArray();
            }
            if (tag == TagType.BYTE_ARRAY || tag == TagType.INT_ARRAY || tag == TagType.LONG_ARRAY) {
                return reader.nextArray(length -> Array.newInstance(this.type, length));
            }
            int length2 = reader.beginList();
            Object array = Array.newInstance(this.type, length2);
            for (int i = 0; i < length2; ++i) {
                E instance = this.typeDeserializer.read(reader);
                Array.set(array, i, instance);
            }
            reader.endList();
            return array;
        }

        @Override
        public void write(Object value, NBTWriter writer) throws IOException {
            if (value instanceof byte[]) {
                writer.value((byte[])value);
            } else if (value instanceof int[]) {
                writer.value((int[])value);
            } else if (value instanceof long[]) {
                writer.value((long[])value);
            } else {
                int length = Array.getLength(value);
                if (length == 0) {
                    writer.beginList(length, this.typeSerializer.type());
                    writer.endList();
                } else {
                    writer.beginList(length);
                    for (int i = 0; i < length; ++i) {
                        this.typeSerializer.write(Objects.requireNonNull(Array.get(value, i), "'null' values are not supported in a list."), writer);
                    }
                    writer.endList();
                }
            }
        }

        @Override
        public TagType type() {
            if (this.type.equals(Byte.TYPE)) {
                return TagType.BYTE_ARRAY;
            }
            if (this.type.equals(Integer.TYPE)) {
                return TagType.INT_ARRAY;
            }
            if (this.type.equals(Long.TYPE)) {
                return TagType.LONG_ARRAY;
            }
            return TagType.LIST;
        }

        public ArrayAdapter(Class<E> type, TypeSerializer<E> typeSerializer, TypeDeserializer<E> typeDeserializer) {
            this.type = type;
            this.typeSerializer = typeSerializer;
            this.typeDeserializer = typeDeserializer;
        }
    }
}

