/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.forge;

import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.common.plugin.text.Text;
import de.bluecolored.bluemap.common.serverinterface.Gamemode;
import de.bluecolored.bluemap.common.serverinterface.Player;
import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import de.bluecolored.bluemap.forge.ForgeMod;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;

public class ForgePlayer
implements Player {
    private static final Map<GameType, Gamemode> GAMEMODE_MAP = new EnumMap<GameType, Gamemode>(GameType.class);
    private final UUID uuid;
    private Text name;
    private ServerWorld world;
    private Vector3d position;
    private Vector3d rotation;
    private int skyLight;
    private int blockLight;
    private boolean sneaking;
    private boolean invisible;
    private Gamemode gamemode;
    private final ForgeMod mod;

    public ForgePlayer(UUID playerUuid, ForgeMod mod) {
        this.uuid = playerUuid;
        this.mod = mod;
        this.update();
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public Text getName() {
        return this.name;
    }

    @Override
    public ServerWorld getWorld() {
        return this.world;
    }

    @Override
    public Vector3d getPosition() {
        return this.position;
    }

    @Override
    public Vector3d getRotation() {
        return this.rotation;
    }

    @Override
    public int getSkyLight() {
        return this.skyLight;
    }

    @Override
    public int getBlockLight() {
        return this.blockLight;
    }

    @Override
    public boolean isSneaking() {
        return this.sneaking;
    }

    @Override
    public boolean isInvisible() {
        return this.invisible;
    }

    @Override
    public Gamemode getGamemode() {
        return this.gamemode;
    }

    public void update() {
        MobEffectInstance invis;
        MinecraftServer server = this.mod.getServer();
        if (server == null) {
            return;
        }
        ServerPlayer player = server.m_6846_().m_11259_(this.uuid);
        if (player == null) {
            return;
        }
        this.gamemode = GAMEMODE_MAP.getOrDefault(player.f_8941_.m_9290_(), Gamemode.SURVIVAL);
        if (this.gamemode == null) {
            this.gamemode = Gamemode.SURVIVAL;
        }
        this.invisible = (invis = player.m_21124_(MobEffects.f_19609_)) != null && invis.m_19557_() > 0;
        this.name = Text.of(player.m_7755_().getString());
        Vec3 pos = player.m_20318_(1.0f);
        this.position = new Vector3d(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
        this.rotation = new Vector3d(player.m_146909_(), player.m_6080_(), 0.0f);
        this.sneaking = player.m_6047_();
        this.skyLight = player.m_9236_().m_7726_().m_7827_().m_75814_(LightLayer.SKY).m_7768_(new BlockPos(player.m_146903_(), player.m_146904_(), player.m_146907_()));
        this.blockLight = player.m_9236_().m_7726_().m_7827_().m_75814_(LightLayer.BLOCK).m_7768_(new BlockPos(player.m_146903_(), player.m_146904_(), player.m_146907_()));
        this.world = this.mod.getServerWorld(player.m_284548_());
    }

    static {
        GAMEMODE_MAP.put(GameType.ADVENTURE, Gamemode.ADVENTURE);
        GAMEMODE_MAP.put(GameType.SURVIVAL, Gamemode.SURVIVAL);
        GAMEMODE_MAP.put(GameType.CREATIVE, Gamemode.CREATIVE);
        GAMEMODE_MAP.put(GameType.SPECTATOR, Gamemode.SPECTATOR);
    }
}

