/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.mca.chunk;

import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.world.BlockState;
import de.bluecolored.bluemap.core.world.Chunk;
import de.bluecolored.bluemap.core.world.block.entity.BlockEntity;
import de.bluecolored.bluemap.core.world.mca.MCAWorld;

public abstract class MCAChunk
implements Chunk {
    protected static final int BLOCKS_PER_SECTION = 4096;
    protected static final int BIOMES_PER_SECTION = 64;
    protected static final int VALUES_PER_HEIGHTMAP = 256;
    protected static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    protected static final int[] EMPTY_INT_ARRAY = new int[0];
    protected static final long[] EMPTY_LONG_ARRAY = new long[0];
    protected static final Key[] EMPTY_KEY_ARRAY = new Key[0];
    protected static final BlockState[] EMPTY_BLOCKSTATE_ARRAY = new BlockState[0];
    protected static final BlockEntity[] EMPTY_BLOCK_ENTITIES_ARRAY = new BlockEntity[0];
    private final MCAWorld world;
    private final int dataVersion;

    public MCAChunk(MCAWorld world, Data chunkData) {
        this.world = world;
        this.dataVersion = chunkData.getDataVersion();
    }

    public MCAWorld getWorld() {
        return this.world;
    }

    public int getDataVersion() {
        return this.dataVersion;
    }

    public String toString() {
        return "MCAChunk(world=" + String.valueOf(this.getWorld()) + ", dataVersion=" + this.getDataVersion() + ")";
    }

    public static class Data {
        private int dataVersion = 0;

        public int getDataVersion() {
            return this.dataVersion;
        }
    }
}

