/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.mca;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3i;
import com.google.gson.reflect.TypeToken;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.resources.pack.datapack.DataPack;
import de.bluecolored.bluemap.core.storage.compression.Compression;
import de.bluecolored.bluemap.core.util.Grid;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.util.Vector2iCache;
import de.bluecolored.bluemap.core.util.WatchService;
import de.bluecolored.bluemap.core.world.Chunk;
import de.bluecolored.bluemap.core.world.ChunkConsumer;
import de.bluecolored.bluemap.core.world.DimensionType;
import de.bluecolored.bluemap.core.world.Region;
import de.bluecolored.bluemap.core.world.World;
import de.bluecolored.bluemap.core.world.mca.MCAUtil;
import de.bluecolored.bluemap.core.world.mca.MCAWorldRegionWatchService;
import de.bluecolored.bluemap.core.world.mca.chunk.ChunkLoader;
import de.bluecolored.bluemap.core.world.mca.data.DimensionTypeDeserializer;
import de.bluecolored.bluemap.core.world.mca.data.LevelData;
import de.bluecolored.bluemap.core.world.mca.region.RegionType;
import de.bluecolored.shadow.benmanes.caffeine.cache.Caffeine;
import de.bluecolored.shadow.benmanes.caffeine.cache.LoadingCache;
import de.bluecolored.shadow.bluenbt.BlueNBT;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class MCAWorld
implements World {
    private static final Grid CHUNK_GRID = new Grid(16);
    private static final Grid REGION_GRID = new Grid(32).multiply(CHUNK_GRID);
    private static final Vector2iCache VECTOR_2_I_CACHE = new Vector2iCache();
    private final String id;
    private final Path worldFolder;
    private final Key dimension;
    private final DataPack dataPack;
    private final LevelData levelData;
    private final DimensionType dimensionType;
    private final Vector3i spawnPoint;
    private final Path dimensionFolder;
    private final Path regionFolder;
    private final ChunkLoader chunkLoader = new ChunkLoader(this);
    private final LoadingCache<Vector2i, Region> regionCache = Caffeine.newBuilder().executor(BlueMap.THREAD_POOL).softValues().maximumSize(32L).expireAfterWrite(10L, TimeUnit.MINUTES).expireAfterAccess(1L, TimeUnit.MINUTES).build(this::loadRegion);
    private final LoadingCache<Vector2i, Chunk> chunkCache = Caffeine.newBuilder().executor(BlueMap.THREAD_POOL).softValues().maximumSize(10240L).expireAfterWrite(10L, TimeUnit.MINUTES).expireAfterAccess(1L, TimeUnit.MINUTES).build(this::loadChunk);

    private MCAWorld(Path worldFolder, Key dimension, DataPack dataPack, LevelData levelData) {
        this.id = World.id(worldFolder, dimension);
        this.worldFolder = worldFolder;
        this.dimension = dimension;
        this.dataPack = dataPack;
        this.levelData = levelData;
        LevelData.Dimension dimensionData = levelData.getData().getWorldGenSettings().getDimensions().get(dimension.getFormatted());
        if (dimensionData == null) {
            if (DataPack.DIMENSION_OVERWORLD.equals(dimension)) {
                dimensionData = new LevelData.Dimension(DimensionType.OVERWORLD);
            } else if (DataPack.DIMENSION_THE_NETHER.equals(dimension)) {
                dimensionData = new LevelData.Dimension(DimensionType.NETHER);
            } else if (DataPack.DIMENSION_THE_END.equals(dimension)) {
                dimensionData = new LevelData.Dimension(DimensionType.END);
            } else {
                Logger.global.logWarning("The level-data does not contain any dimension with the id '" + String.valueOf(dimension) + "', using fallback.");
                dimensionData = new LevelData.Dimension();
            }
        }
        this.dimensionType = dimensionData.getType();
        this.spawnPoint = new Vector3i(levelData.getData().getSpawnX(), levelData.getData().getSpawnY(), levelData.getData().getSpawnZ());
        this.dimensionFolder = MCAWorld.resolveDimensionFolder(worldFolder, dimension);
        this.regionFolder = this.dimensionFolder.resolve("region");
    }

    @Override
    public String getName() {
        return this.levelData.getData().getLevelName();
    }

    @Override
    public Grid getChunkGrid() {
        return CHUNK_GRID;
    }

    @Override
    public Grid getRegionGrid() {
        return REGION_GRID;
    }

    @Override
    public Chunk getChunkAtBlock(int x, int z) {
        return this.getChunk(x >> 4, z >> 4);
    }

    @Override
    public Chunk getChunk(int x, int z) {
        return this.getChunk(VECTOR_2_I_CACHE.get(x, z));
    }

    private Chunk getChunk(Vector2i pos) {
        return this.chunkCache.get(pos);
    }

    @Override
    public Region getRegion(int x, int z) {
        return this.getRegion(VECTOR_2_I_CACHE.get(x, z));
    }

    private Region getRegion(Vector2i pos) {
        return this.regionCache.get(pos);
    }

    @Override
    public Collection<Vector2i> listRegions() {
        List<Vector2i> list;
        block9: {
            if (!Files.exists(this.regionFolder, new LinkOption[0])) {
                return Collections.emptyList();
            }
            Stream<Path> stream = Files.list(this.regionFolder);
            try {
                list = stream.map(file -> {
                    try {
                        if (Files.size(file) <= 0L) {
                            return null;
                        }
                        return RegionType.regionForFileName(file.getFileName().toString());
                    }
                    catch (IOException ex) {
                        Logger.global.logError("Failed to read region-file: " + String.valueOf(file), ex);
                        return null;
                    }
                }).filter(Objects::nonNull).toList();
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    Logger.global.logError("Failed to list regions for world: '" + this.getId() + "'", ex);
                    return List.of();
                }
            }
            stream.close();
        }
        return list;
    }

    @Override
    public WatchService<Vector2i> createRegionWatchService() throws IOException {
        return new MCAWorldRegionWatchService(this.regionFolder);
    }

    @Override
    public void preloadRegionChunks(int x, int z, final Predicate<Vector2i> chunkFilter) {
        try {
            this.getRegion(x, z).iterateAllChunks(new ChunkConsumer(){

                @Override
                public boolean filter(int chunkX, int chunkZ, int lastModified) {
                    Vector2i chunkPos = VECTOR_2_I_CACHE.get(chunkX, chunkZ);
                    return chunkFilter.test(chunkPos);
                }

                @Override
                public void accept(int chunkX, int chunkZ, Chunk chunk) {
                    Vector2i chunkPos = VECTOR_2_I_CACHE.get(chunkX, chunkZ);
                    MCAWorld.this.chunkCache.put(chunkPos, chunk);
                }
            });
        }
        catch (IOException ex) {
            Logger.global.logDebug("Unexpected exception trying to load preload region (x:" + x + ", z:" + z + "): " + String.valueOf(ex));
        }
    }

    @Override
    public void invalidateChunkCache() {
        this.regionCache.invalidateAll();
        this.chunkCache.invalidateAll();
    }

    @Override
    public void invalidateChunkCache(int x, int z) {
        this.regionCache.invalidate(VECTOR_2_I_CACHE.get(x >> 5, z >> 5));
        this.chunkCache.invalidate(VECTOR_2_I_CACHE.get(x, z));
    }

    private Region loadRegion(Vector2i regionPos) {
        return this.loadRegion(regionPos.getX(), regionPos.getY());
    }

    private Region loadRegion(int x, int z) {
        return RegionType.loadRegion(this, this.getRegionFolder(), x, z);
    }

    private Chunk loadChunk(Vector2i chunkPos) {
        return this.loadChunk(chunkPos.getX(), chunkPos.getY());
    }

    private Chunk loadChunk(int x, int z) {
        int tries = 3;
        int tryInterval = 1000;
        Exception loadException = null;
        for (int i = 0; i < 3; ++i) {
            try {
                return this.getRegion(x >> 5, z >> 5).loadChunk(x, z);
            }
            catch (IOException | RuntimeException e) {
                if (loadException != null && loadException != e) {
                    e.addSuppressed(loadException);
                }
                loadException = e;
                if (i + 1 >= 3) continue;
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        Logger.global.logDebug("Unexpected exception trying to load chunk (x:" + x + ", z:" + z + "): " + String.valueOf(loadException));
        return Chunk.ERRORED_CHUNK;
    }

    public static MCAWorld load(Path worldFolder, Key dimension, DataPack dataPack) throws IOException, InterruptedException {
        LevelData levelData;
        Path levelFile = worldFolder.resolve("level.dat");
        BlueNBT blueNBT = MCAWorld.createBlueNBTForDataPack(dataPack);
        try (InputStream levelFileIn = Compression.GZIP.decompress(Files.newInputStream(levelFile, new OpenOption[0]));){
            levelData = blueNBT.read(levelFileIn, LevelData.class);
        }
        return new MCAWorld(worldFolder, dimension, dataPack, levelData);
    }

    public static Path resolveDimensionFolder(Path worldFolder, Key dimension) {
        if (DataPack.DIMENSION_OVERWORLD.equals(dimension)) {
            return worldFolder;
        }
        if (DataPack.DIMENSION_THE_NETHER.equals(dimension)) {
            return worldFolder.resolve("DIM-1");
        }
        if (DataPack.DIMENSION_THE_END.equals(dimension)) {
            return worldFolder.resolve("DIM1");
        }
        return worldFolder.resolve("dimensions").resolve(dimension.getNamespace()).resolve(dimension.getValue());
    }

    private static BlueNBT createBlueNBTForDataPack(DataPack dataPack) {
        BlueNBT blueNBT = MCAUtil.addCommonNbtAdapters(new BlueNBT());
        blueNBT.register(TypeToken.get(DimensionType.class), new DimensionTypeDeserializer(blueNBT, dataPack));
        return blueNBT;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Path getWorldFolder() {
        return this.worldFolder;
    }

    public Key getDimension() {
        return this.dimension;
    }

    public DataPack getDataPack() {
        return this.dataPack;
    }

    public LevelData getLevelData() {
        return this.levelData;
    }

    @Override
    public DimensionType getDimensionType() {
        return this.dimensionType;
    }

    @Override
    public Vector3i getSpawnPoint() {
        return this.spawnPoint;
    }

    public Path getDimensionFolder() {
        return this.dimensionFolder;
    }

    public Path getRegionFolder() {
        return this.regionFolder;
    }

    public ChunkLoader getChunkLoader() {
        return this.chunkLoader;
    }

    public LoadingCache<Vector2i, Region> getRegionCache() {
        return this.regionCache;
    }

    public LoadingCache<Vector2i, Chunk> getChunkCache() {
        return this.chunkCache;
    }

    public String toString() {
        return "MCAWorld(id=" + this.getId() + ", worldFolder=" + String.valueOf(this.getWorldFolder()) + ", dimension=" + String.valueOf(this.getDimension()) + ", dataPack=" + String.valueOf(this.getDataPack()) + ", levelData=" + String.valueOf(this.getLevelData()) + ", dimensionType=" + String.valueOf(this.getDimensionType()) + ", spawnPoint=" + String.valueOf(this.getSpawnPoint()) + ", dimensionFolder=" + String.valueOf(this.getDimensionFolder()) + ", regionFolder=" + String.valueOf(this.getRegionFolder()) + ", chunkLoader=" + String.valueOf(this.getChunkLoader()) + ", regionCache=" + String.valueOf(this.getRegionCache()) + ", chunkCache=" + String.valueOf(this.getChunkCache()) + ")";
    }
}

