/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.mca;

import com.google.gson.reflect.TypeToken;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.world.BlockState;
import de.bluecolored.bluemap.core.world.block.entity.BlockEntity;
import de.bluecolored.bluemap.core.world.mca.data.BlockStateDeserializer;
import de.bluecolored.bluemap.core.world.mca.data.KeyDeserializer;
import de.bluecolored.shadow.bluenbt.BlueNBT;
import org.jetbrains.annotations.Contract;

public class MCAUtil {
    public static final BlueNBT BLUENBT = MCAUtil.addCommonNbtAdapters(new BlueNBT());

    @Contract(value="_ -> param1", mutates="param1")
    public static BlueNBT addCommonNbtAdapters(BlueNBT nbt) {
        nbt.register(TypeToken.get(BlockState.class), new BlockStateDeserializer());
        nbt.register(TypeToken.get(Key.class), new KeyDeserializer());
        nbt.register(TypeToken.get(BlockEntity.class), new BlockEntity.BlockEntityDeserializer(nbt));
        return nbt;
    }

    public static long getValueFromLongArray(long[] data, int valueIndex, int bitsPerValue) {
        int valuesPerLong = 64 / bitsPerValue;
        int longIndex = valueIndex / valuesPerLong;
        int bitIndex = valueIndex % valuesPerLong * bitsPerValue;
        if (longIndex >= data.length) {
            return 0L;
        }
        long value = data[longIndex] >>> bitIndex;
        return value & -1L >>> -bitsPerValue;
    }

    public static long getValueFromLongStream(long[] data, int valueIndex, int bitsPerValue) {
        int bitIndex = valueIndex * bitsPerValue;
        int firstLong = bitIndex >> 6;
        int bitOffset = bitIndex & 0x3F;
        if (firstLong >= data.length) {
            return 0L;
        }
        long value = data[firstLong] >>> bitOffset;
        if (bitOffset > 0 && firstLong + 1 < data.length) {
            long value2 = data[firstLong + 1];
            value |= (value2 <<= -bitOffset);
        }
        return value & -1L >>> -bitsPerValue;
    }

    public static int getByteHalf(int value, boolean largeHalf) {
        if (largeHalf) {
            return value >> 4 & 0xF;
        }
        return value & 0xF;
    }

    public static int ceilLog2(int n) {
        return 32 - Integer.numberOfLeadingZeros(n - 1);
    }
}

