/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.block.entity;

import de.bluecolored.bluemap.core.world.block.entity.BlockEntity;
import java.util.List;
import java.util.Map;

public class SignBlockEntity
extends BlockEntity {
    private final TextData frontText;
    private final TextData backText;

    protected SignBlockEntity(Map<String, Object> data) {
        super(data);
        if (data.containsKey("front_text")) {
            this.frontText = new TextData(data.getOrDefault("front_text", Map.of()));
            this.backText = new TextData(data.getOrDefault("back_text", Map.of()));
        } else {
            this.frontText = new TextData((Byte)data.getOrDefault("GlowingText", (byte)0) == 1, (String)data.getOrDefault("Color", ""), List.of((String)data.getOrDefault("Text1", ""), (String)data.getOrDefault("Text2", ""), (String)data.getOrDefault("Text3", ""), (String)data.getOrDefault("Text4", "")));
            this.backText = new TextData(false, "", List.of());
        }
    }

    public TextData getFrontText() {
        return this.frontText;
    }

    public TextData getBackText() {
        return this.backText;
    }

    @Override
    public String toString() {
        return "SignBlockEntity{frontText=" + String.valueOf(this.frontText) + ", backText=" + String.valueOf(this.backText) + "} " + super.toString();
    }

    public static class TextData {
        private final boolean hasGlowingText;
        private final String color;
        private final List<String> messages;

        private TextData(Map<String, Object> data) {
            this.hasGlowingText = (Byte)data.getOrDefault("has_glowing_text", (byte)0) == 1;
            this.color = (String)data.getOrDefault("color", "");
            this.messages = data.getOrDefault("messages", List.of());
        }

        public TextData(boolean hasGlowingText, String color, List<String> messages) {
            this.hasGlowingText = hasGlowingText;
            this.color = color;
            this.messages = messages;
        }

        public boolean isHasGlowingText() {
            return this.hasGlowingText;
        }

        public String getColor() {
            return this.color;
        }

        public List<String> getMessages() {
            return this.messages;
        }

        public String toString() {
            return "TextData{hasGlowingText=" + this.hasGlowingText + ", color='" + this.color + "', messages=" + String.valueOf(this.messages) + "}";
        }
    }
}

