/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.block.entity;

import com.google.gson.reflect.TypeToken;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.world.block.entity.BlockEntityType;
import de.bluecolored.shadow.bluenbt.BlueNBT;
import de.bluecolored.shadow.bluenbt.NBTDeserializer;
import de.bluecolored.shadow.bluenbt.NBTReader;
import de.bluecolored.shadow.bluenbt.TypeDeserializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

@NBTDeserializer(value=BlockEntityDeserializer.class)
public abstract class BlockEntity {
    protected final String id;
    protected final int x;
    protected final int y;
    protected final int z;
    protected final boolean keepPacked;

    protected BlockEntity(Map<String, Object> raw) {
        this.id = (String)raw.get("id");
        this.x = (Integer)raw.getOrDefault("x", 0);
        this.y = (Integer)raw.getOrDefault("y", 0);
        this.z = (Integer)raw.getOrDefault("z", 0);
        this.keepPacked = (Byte)raw.getOrDefault("keepPacked", (byte)0) == 1;
    }

    public String getId() {
        return this.id;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public boolean isKeepPacked() {
        return this.keepPacked;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockEntity)) {
            return false;
        }
        BlockEntity other = (BlockEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getY() != other.getY()) {
            return false;
        }
        if (this.getZ() != other.getZ()) {
            return false;
        }
        if (this.isKeepPacked() != other.isKeepPacked()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlockEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getY();
        result = result * 59 + this.getZ();
        result = result * 59 + (this.isKeepPacked() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    public String toString() {
        return "BlockEntity(id=" + this.getId() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", keepPacked=" + this.isKeepPacked() + ")";
    }

    public static class BlockEntityDeserializer
    implements TypeDeserializer<BlockEntity> {
        private final BlueNBT blueNBT;

        @Override
        @Nullable
        public BlockEntity read(NBTReader reader) throws IOException {
            Map raw = (Map)this.blueNBT.read(reader, TypeToken.getParameterized(Map.class, (Type[])new Type[]{String.class, Object.class}));
            String id = (String)raw.get("id");
            if (id == null) {
                return null;
            }
            Key typeKey = Key.parse(id, "minecraft");
            BlockEntityType type = BlockEntityType.REGISTRY.get(typeKey);
            if (type == null) {
                return null;
            }
            return type.load(raw);
        }

        public BlockEntityDeserializer(BlueNBT blueNBT) {
            this.blueNBT = blueNBT;
        }
    }
}

