/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.block;

import de.bluecolored.bluemap.core.world.BlockState;
import de.bluecolored.bluemap.core.world.Chunk;
import de.bluecolored.bluemap.core.world.LightData;
import de.bluecolored.bluemap.core.world.World;
import de.bluecolored.bluemap.core.world.biome.Biome;
import de.bluecolored.bluemap.core.world.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class Block<T extends Block<T>> {
    private World world;
    private int x;
    private int y;
    private int z;
    @Nullable
    private Chunk chunk;
    @Nullable
    private BlockState blockState;
    private final LightData lightData = new LightData(-1, -1);
    @Nullable
    private Biome biome;

    public Block(World world, int x, int y, int z) {
        this.set(world, x, y, z);
    }

    public T set(World world, int x, int y, int z) {
        if (this.x == x && this.z == z && this.world == world) {
            if (this.y == y) {
                return this.self();
            }
        } else {
            this.chunk = null;
        }
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.reset();
        return this.self();
    }

    public T set(int x, int y, int z) {
        if (this.x == x && this.z == z) {
            if (this.y == y) {
                return this.self();
            }
        } else {
            this.chunk = null;
        }
        this.x = x;
        this.y = y;
        this.z = z;
        this.reset();
        return this.self();
    }

    protected void reset() {
        this.blockState = null;
        this.lightData.set(-1, -1);
        this.biome = null;
    }

    public T add(int dx, int dy, int dz) {
        return this.set(this.x + dx, this.y + dy, this.z + dz);
    }

    public T copy(Block<?> source) {
        this.world = source.world;
        this.chunk = source.chunk;
        this.x = source.x;
        this.y = source.y;
        this.z = source.z;
        this.reset();
        this.blockState = source.blockState;
        this.lightData.set(source.lightData.getSkyLight(), source.lightData.getBlockLight());
        this.biome = source.biome;
        return this.self();
    }

    public World getWorld() {
        return this.world;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public Chunk getChunk() {
        if (this.chunk == null) {
            this.chunk = this.world.getChunkAtBlock(this.x, this.z);
        }
        return this.chunk;
    }

    public BlockState getBlockState() {
        if (this.blockState == null) {
            this.blockState = this.getChunk().getBlockState(this.x, this.y, this.z);
        }
        return this.blockState;
    }

    public LightData getLightData() {
        if (this.lightData.getSkyLight() < 0) {
            this.getChunk().getLightData(this.x, this.y, this.z, this.lightData);
        }
        return this.lightData;
    }

    public Biome getBiome() {
        if (this.biome == null) {
            this.biome = this.getChunk().getBiome(this.x, this.y, this.z);
        }
        return this.biome;
    }

    public int getSunLightLevel() {
        return this.getLightData().getSkyLight();
    }

    public int getBlockLightLevel() {
        return this.getLightData().getBlockLight();
    }

    @Nullable
    public BlockEntity getBlockEntity() {
        return this.getChunk().getBlockEntity(this.x, this.y, this.z);
    }

    public String toString() {
        if (this.world != null) {
            return "Block{world=" + String.valueOf(this.world) + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", chunk=" + String.valueOf(this.getChunk()) + ", blockState=" + String.valueOf(this.getBlockState()) + ", lightData=" + String.valueOf(this.getLightData()) + ", biome=" + String.valueOf(this.getBiome()) + "}";
        }
        return "Block{world=null, x=" + this.x + ", y=" + this.y + ", z=" + this.z + "}";
    }

    protected T self() {
        return (T)this;
    }
}

