/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack.resourcepack.blockstate;

import com.google.gson.Gson;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import de.bluecolored.bluemap.core.resources.AbstractTypeAdapterFactory;
import de.bluecolored.bluemap.core.resources.ResourcePath;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.blockmodel.BlockModel;
import de.bluecolored.bluemap.core.util.math.MatrixM3f;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public class Variant {
    private ResourcePath<BlockModel> model = ResourcePack.MISSING_BLOCK_MODEL;
    private float x = 0.0f;
    private float y = 0.0f;
    private boolean uvlock = false;
    private double weight = 1.0;
    private transient boolean rotated;
    private transient MatrixM3f rotationMatrix;

    private Variant() {
    }

    private void init() {
        this.rotated = this.x != 0.0f || this.y != 0.0f;
        this.rotationMatrix = new MatrixM3f().rotate(-this.x, -this.y, 0.0f);
    }

    public ResourcePath<BlockModel> getModel() {
        return this.model;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public boolean isUvlock() {
        return this.uvlock;
    }

    public double getWeight() {
        return this.weight;
    }

    public boolean isRotated() {
        return this.rotated;
    }

    public MatrixM3f getRotationMatrix() {
        return this.rotationMatrix;
    }

    static class Adapter
    extends AbstractTypeAdapterFactory<Variant> {
        public Adapter() {
            super(Variant.class);
        }

        @Override
        public Variant read(JsonReader in, Gson gson) throws IOException {
            Variant variant = (Variant)gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Variant.class)).read(in);
            variant.init();
            return variant;
        }
    }
}

