/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack.resourcepack.blockmodel;

import com.flowpowered.math.TrigMath;
import com.flowpowered.math.vector.Vector3f;
import com.flowpowered.math.vector.Vector3i;
import com.google.gson.Gson;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import de.bluecolored.bluemap.core.resources.AbstractTypeAdapterFactory;
import de.bluecolored.bluemap.core.util.math.Axis;
import de.bluecolored.bluemap.core.util.math.MatrixM4f;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public class Rotation {
    private static final Vector3f DEFAULT_ORIGIN = new Vector3f(8.0f, 8.0f, 8.0f);
    private static final double FIT_TO_BLOCK_SCALE_MULTIPLIER = 2.0 - Math.sqrt(2.0);
    public static final Rotation ZERO = new Rotation();
    private Vector3f origin = DEFAULT_ORIGIN;
    private Axis axis = Axis.Y;
    private float angle = 0.0f;
    private boolean rescale = false;
    private transient MatrixM4f matrix;

    private Rotation() {
    }

    private void init() {
        Vector3i axisAngle = this.axis.toVector();
        this.matrix = new MatrixM4f();
        if (this.angle != 0.0f) {
            this.matrix.translate(-this.origin.getX(), -this.origin.getY(), -this.origin.getZ());
            this.matrix.rotate(this.angle, axisAngle.getX(), axisAngle.getY(), axisAngle.getZ());
            if (this.rescale) {
                float scale = (float)((double)Math.abs(TrigMath.sin((double)this.angle * (Math.PI / 180))) * FIT_TO_BLOCK_SCALE_MULTIPLIER);
                this.matrix.scale((float)(1 - axisAngle.getX()) * scale + 1.0f, (float)(1 - axisAngle.getY()) * scale + 1.0f, (float)(1 - axisAngle.getZ()) * scale + 1.0f);
            }
            this.matrix.translate(this.origin.getX(), this.origin.getY(), this.origin.getZ());
        }
    }

    public Vector3f getOrigin() {
        return this.origin;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public double getAngle() {
        return this.angle;
    }

    public boolean isRescale() {
        return this.rescale;
    }

    public MatrixM4f getMatrix() {
        return this.matrix;
    }

    static {
        ZERO.init();
    }

    static class Adapter
    extends AbstractTypeAdapterFactory<Rotation> {
        public Adapter() {
            super(Rotation.class);
        }

        @Override
        public Rotation read(JsonReader in, Gson gson) throws IOException {
            Rotation rotation = (Rotation)gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Rotation.class)).read(in);
            rotation.init();
            return rotation;
        }
    }
}

