/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack.resourcepack.blockmodel;

import de.bluecolored.bluemap.core.resources.ResourcePath;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.blockmodel.Element;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.blockmodel.Face;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.blockmodel.TextureVariable;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.texture.Texture;
import de.bluecolored.bluemap.core.util.Direction;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class BlockModel {
    private ResourcePath<BlockModel> parent;
    private Map<String, TextureVariable> textures = new HashMap<String, TextureVariable>();
    private Element[] elements;
    private boolean ambientocclusion = true;
    private transient boolean liquid = false;
    private transient boolean culling = false;
    private transient boolean occluding = false;

    private BlockModel() {
    }

    @Nullable
    public ResourcePath<BlockModel> getParent() {
        return this.parent;
    }

    public Map<String, TextureVariable> getTextures() {
        return this.textures;
    }

    @Nullable
    public Element[] getElements() {
        return this.elements;
    }

    public boolean isAmbientocclusion() {
        return this.ambientocclusion;
    }

    public boolean isLiquid() {
        return this.liquid;
    }

    public boolean isCulling() {
        return this.culling;
    }

    public boolean isOccluding() {
        return this.occluding;
    }

    public synchronized void optimize(ResourcePack resourcePack) {
        for (TextureVariable variable : this.textures.values()) {
            variable.optimize(resourcePack);
        }
        if (this.elements != null) {
            for (Element element : this.elements) {
                if (element == null) continue;
                element.optimize(resourcePack);
            }
        }
    }

    public synchronized void applyParent(ResourcePack resourcePack) {
        if (this.parent == null) {
            return;
        }
        ResourcePath<BlockModel> parentPath = this.parent;
        this.parent = null;
        if (parentPath.getFormatted().equals("bluemap:builtin/liquid")) {
            this.liquid = true;
            return;
        }
        BlockModel parent = parentPath.getResource(resourcePack::getBlockModel);
        if (parent != null) {
            parent.applyParent(resourcePack);
            parent.textures.forEach(this::applyTextureVariable);
            if (this.elements == null && parent.elements != null) {
                this.elements = new Element[parent.elements.length];
                for (int i = 0; i < this.elements.length; ++i) {
                    if (parent.elements[i] == null) continue;
                    this.elements[i] = parent.elements[i].copy();
                }
            }
        }
    }

    private synchronized void applyTextureVariable(String key, TextureVariable value) {
        if (!this.textures.containsKey(key)) {
            this.textures.put(key, value.copy());
        }
    }

    public synchronized void calculateProperties(ResourcePack resourcePack) {
        if (this.elements == null) {
            return;
        }
        block0: for (Element element : this.elements) {
            if (element == null || !element.isFullCube()) continue;
            this.occluding = true;
            this.culling = true;
            for (Direction dir : Direction.values()) {
                Face face = element.getFaces().get((Object)dir);
                if (face == null) {
                    this.culling = false;
                    break block0;
                }
                ResourcePath<Texture> textureResourcePath = face.getTexture().getTexturePath(this.textures::get);
                if (textureResourcePath == null) {
                    this.culling = false;
                    break block0;
                }
                Texture texture = textureResourcePath.getResource(resourcePack::getTexture);
                if (texture != null && !(texture.getColorStraight().a < 1.0f)) continue;
                this.culling = false;
                break block0;
            }
            break;
        }
    }
}

