/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.renderstate;

import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.renderstate.CellStorage;
import de.bluecolored.bluemap.core.map.renderstate.TileInfoRegion;
import de.bluecolored.bluemap.core.map.renderstate.TileState;
import de.bluecolored.bluemap.core.storage.GridStorage;
import de.bluecolored.bluemap.core.util.Grid;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class MapTileState
extends CellStorage<TileInfoRegion> {
    static final int SHIFT = 5;
    public static final Grid GRID = new Grid(32);
    private int lastRenderTime = -1;
    private final Map<TileState, Integer> chunkStateCounts = new ConcurrentHashMap<TileState, Integer>();

    public MapTileState(GridStorage storage) {
        super(storage, TileInfoRegion.class);
    }

    public synchronized void load() {
        this.lastRenderTime = -1;
        this.chunkStateCounts.clear();
        try (Stream<GridStorage.Cell> stream = this.getStorage().stream();){
            stream.forEach(cell -> {
                TileInfoRegion region = (TileInfoRegion)this.cell(cell.getX(), cell.getZ());
                this.lastRenderTime = Math.max(this.lastRenderTime, region.findLatestRenderTime());
                region.populateSummaryMap(this.chunkStateCounts);
            });
        }
        catch (IOException e) {
            Logger.global.logError("Failed to load render-state regions", e);
        }
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.load();
    }

    public TileInfoRegion.TileInfo get(int x, int z) {
        return ((TileInfoRegion)this.cell(x >> 5, z >> 5)).get(x, z);
    }

    public synchronized TileInfoRegion.TileInfo set(int x, int z, TileInfoRegion.TileInfo info) {
        TileInfoRegion.TileInfo old = ((TileInfoRegion)this.cell(x >> 5, z >> 5)).set(x, z, info);
        if (info.getRenderTime() > this.lastRenderTime) {
            this.lastRenderTime = info.getRenderTime();
        }
        if (old.getState() != info.getState()) {
            this.chunkStateCounts.merge(old.getState(), -1, Integer::sum);
            this.chunkStateCounts.merge(info.getState(), 1, Integer::sum);
        }
        return old;
    }

    public Map<TileState, Integer> getChunkStateCounts() {
        return Collections.unmodifiableMap(this.chunkStateCounts);
    }

    @Override
    protected synchronized TileInfoRegion createNewCell() {
        TileInfoRegion region = TileInfoRegion.create();
        region.populateSummaryMap(this.chunkStateCounts);
        return region;
    }

    public int getLastRenderTime() {
        return this.lastRenderTime;
    }
}

