/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.hires.blockmodel;

import de.bluecolored.bluemap.core.map.TextureGallery;
import de.bluecolored.bluemap.core.map.hires.BlockModelView;
import de.bluecolored.bluemap.core.map.hires.RenderSettings;
import de.bluecolored.bluemap.core.map.hires.blockmodel.LiquidModelBuilder;
import de.bluecolored.bluemap.core.map.hires.blockmodel.ResourceModelBuilder;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.blockmodel.BlockModel;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.blockstate.BlockState;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.blockstate.Variant;
import de.bluecolored.bluemap.core.util.math.Color;
import de.bluecolored.bluemap.core.world.block.BlockNeighborhood;
import java.util.ArrayList;
import java.util.List;

public class BlockStateModelFactory {
    private final ResourcePack resourcePack;
    private final ResourceModelBuilder resourceModelBuilder;
    private final LiquidModelBuilder liquidModelBuilder;
    private final List<Variant> variants = new ArrayList<Variant>();
    private final Color waterloggedColor = new Color();
    private final Color variantColor = new Color();
    private static final de.bluecolored.bluemap.core.world.BlockState WATERLOGGED_BLOCKSTATE = new de.bluecolored.bluemap.core.world.BlockState("minecraft:water");

    public BlockStateModelFactory(ResourcePack resourcePack, TextureGallery textureGallery, RenderSettings renderSettings) {
        this.resourcePack = resourcePack;
        this.resourceModelBuilder = new ResourceModelBuilder(resourcePack, textureGallery, renderSettings);
        this.liquidModelBuilder = new LiquidModelBuilder(resourcePack, textureGallery, renderSettings);
    }

    public void render(BlockNeighborhood<?> block, BlockModelView blockModel, Color blockColor) {
        this.render(block, block.getBlockState(), blockModel, blockColor);
    }

    public void render(BlockNeighborhood<?> block, de.bluecolored.bluemap.core.world.BlockState blockState, BlockModelView blockModel, Color blockColor) {
        blockColor.set(0.0f, 0.0f, 0.0f, 0.0f, true);
        if (blockState.isAir()) {
            return;
        }
        int modelStart = blockModel.getStart();
        this.renderModel(block, blockState, blockModel.initialize(), blockColor);
        if (blockState.isWaterlogged() || block.getProperties().isAlwaysWaterlogged()) {
            this.waterloggedColor.set(0.0f, 0.0f, 0.0f, 0.0f, true);
            this.renderModel(block, WATERLOGGED_BLOCKSTATE, blockModel.initialize(), this.waterloggedColor);
            blockColor.set(this.waterloggedColor.overlay(blockColor.premultiplied()));
        }
        blockModel.initialize(modelStart);
    }

    private void renderModel(BlockNeighborhood<?> block, de.bluecolored.bluemap.core.world.BlockState blockState, BlockModelView blockModel, Color blockColor) {
        int modelStart = blockModel.getStart();
        BlockState stateResource = this.resourcePack.getBlockState(blockState);
        if (stateResource == null) {
            return;
        }
        float blockColorOpacity = 0.0f;
        this.variants.clear();
        stateResource.forEach(blockState, block.getX(), block.getY(), block.getZ(), this.variants::add);
        for (int i = 0; i < this.variants.size(); ++i) {
            Variant variant = this.variants.get(i);
            BlockModel modelResource = variant.getModel().getResource(this.resourcePack::getBlockModel);
            if (modelResource == null) continue;
            this.variantColor.set(0.0f, 0.0f, 0.0f, 0.0f, true);
            if (modelResource.isLiquid()) {
                this.liquidModelBuilder.build(block, blockState, variant, blockModel.initialize(), this.variantColor);
            } else {
                this.resourceModelBuilder.build(block, variant, blockModel.initialize(), this.variantColor);
            }
            if (this.variantColor.a > blockColorOpacity) {
                blockColorOpacity = this.variantColor.a;
            }
            blockColor.add(this.variantColor.premultiplied());
        }
        if (blockColor.a > 0.0f) {
            blockColor.flatten().straight();
            blockColor.a = blockColorOpacity;
        }
        blockModel.initialize(modelStart);
    }
}

