/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.hires;

import de.bluecolored.bluemap.core.map.hires.TileModel;
import de.bluecolored.bluemap.core.util.math.MatrixM3f;
import de.bluecolored.bluemap.core.util.math.MatrixM4f;

public class BlockModelView {
    private TileModel hiresTile;
    private int start;
    private int size;

    public BlockModelView(TileModel hiresTile) {
        this.initialize(hiresTile);
    }

    public BlockModelView initialize(TileModel hiresTile, int start) {
        this.hiresTile = hiresTile;
        this.start = start;
        this.size = hiresTile.size() - start;
        return this;
    }

    public BlockModelView initialize(TileModel hiresTile) {
        this.hiresTile = hiresTile;
        this.start = hiresTile.size();
        this.size = 0;
        return this;
    }

    public BlockModelView initialize(int start) {
        this.start = start;
        this.size = this.hiresTile.size() - start;
        return this;
    }

    public BlockModelView initialize() {
        this.start = this.hiresTile.size();
        this.size = 0;
        return this;
    }

    public BlockModelView reset() {
        this.hiresTile.reset(this.start);
        this.size = 0;
        return this;
    }

    public int add(int count) {
        int s2 = this.hiresTile.add(count);
        if (s2 != this.start + this.size) {
            throw new IllegalStateException("Size of HiresTileModel had external changes since view-initialisation!");
        }
        this.size += count;
        return s2;
    }

    public BlockModelView rotate(float angle, float axisX, float axisY, float axisZ) {
        this.hiresTile.rotate(this.start, this.size, angle, axisX, axisY, axisZ);
        return this;
    }

    public BlockModelView rotate(float pitch, float yaw, float roll) {
        this.hiresTile.rotate(this.start, this.size, pitch, yaw, roll);
        return this;
    }

    public BlockModelView scale(float sx, float sy, float sz) {
        this.hiresTile.scale(this.start, this.size, sx, sy, sz);
        return this;
    }

    public BlockModelView translate(float dx, float dy, float dz) {
        this.hiresTile.translate(this.start, this.size, dx, dy, dz);
        return this;
    }

    public BlockModelView transform(MatrixM3f t2) {
        this.hiresTile.transform(this.start, this.size, t2);
        return this;
    }

    public BlockModelView transform(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        this.hiresTile.transform(this.start, this.size, m00, m01, m02, m10, m11, m12, m20, m21, m22);
        return this;
    }

    public BlockModelView transform(MatrixM4f t2) {
        this.hiresTile.transform(this.start, this.size, t2);
        return this;
    }

    public BlockModelView transform(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33) {
        this.hiresTile.transform(this.start, this.size, m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33);
        return this;
    }

    public TileModel getHiresTile() {
        return this.hiresTile;
    }

    public int getStart() {
        return this.start;
    }

    public int getSize() {
        return this.size;
    }
}

