/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.serverinterface;

import de.bluecolored.bluemap.common.debug.DebugDump;
import de.bluecolored.bluemap.common.serverinterface.Player;
import de.bluecolored.bluemap.common.serverinterface.ServerEventListener;
import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import de.bluecolored.bluemap.core.util.Tristate;
import de.bluecolored.bluemap.core.world.World;
import de.bluecolored.bluemap.core.world.mca.MCAWorld;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public interface Server {
    @DebugDump
    @Nullable
    public String getMinecraftVersion();

    @DebugDump
    public Path getConfigFolder();

    @DebugDump
    public Optional<Path> getModsFolder();

    @DebugDump
    default public Tristate isMetricsEnabled() {
        return Tristate.UNDEFINED;
    }

    default public Optional<ServerWorld> getServerWorld(World world) {
        if (world instanceof MCAWorld) {
            MCAWorld mcaWorld = (MCAWorld)world;
            return this.getLoadedServerWorlds().stream().filter(serverWorld -> serverWorld.getWorldFolder().toAbsolutePath().normalize().equals(mcaWorld.getWorldFolder().toAbsolutePath().normalize()) && serverWorld.getDimension().equals(mcaWorld.getDimension())).findAny();
        }
        return Optional.empty();
    }

    default public Optional<ServerWorld> getServerWorld(Object world) {
        if (world instanceof World) {
            return this.getServerWorld((World)world);
        }
        return Optional.empty();
    }

    @DebugDump
    public Collection<ServerWorld> getLoadedServerWorlds();

    @DebugDump
    public Collection<Player> getOnlinePlayers();

    public void registerListener(ServerEventListener var1);

    public void unregisterAllListeners();
}

