/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.addons;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.bluecolored.bluemap.common.addons.AddonException;
import de.bluecolored.bluemap.common.addons.AddonInfo;
import de.bluecolored.bluemap.common.addons.LoadedAddon;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.logger.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public final class Addons {
    private static final Gson GSON = new GsonBuilder().create();
    private static final Map<String, LoadedAddon> LOADED_ADDONS = new ConcurrentHashMap<String, LoadedAddon>();

    private Addons() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void tryLoadAddons(Path root) {
        Addons.tryLoadAddons(root, false);
    }

    public static void tryLoadAddons(Path root, boolean expectOnlyAddons) {
        if (!Files.exists(root, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> files = Files.list(root);){
            files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(f -> f.getFileName().toString().endsWith(".jar")).forEach(expectOnlyAddons ? Addons::tryLoadAddon : Addons::tryLoadJar);
        }
        catch (IOException e) {
            Logger.global.logError("Failed to load addons from '%s'".formatted(root), e);
        }
    }

    public static void tryLoadAddon(Path addonJarFile) {
        try {
            AddonInfo addonInfo = Addons.loadAddonInfo(addonJarFile);
            if (addonInfo == null) {
                throw new AddonException("No %s found in '%s'".formatted("bluemap.addon.json", addonJarFile));
            }
            if (LOADED_ADDONS.containsKey(addonInfo.getId())) {
                return;
            }
            Addons.loadAddon(addonJarFile, addonInfo);
        }
        catch (AddonException | IOException e) {
            Logger.global.logError("Failed to load addon '%s'".formatted(addonJarFile), e);
        }
    }

    public static void tryLoadJar(Path addonJarFile) {
        try {
            AddonInfo addonInfo = Addons.loadAddonInfo(addonJarFile);
            if (addonInfo == null) {
                Logger.global.logDebug("No %s found in '%s', skipping...".formatted("bluemap.addon.json", addonJarFile));
                return;
            }
            if (LOADED_ADDONS.containsKey(addonInfo.getId())) {
                return;
            }
            Addons.loadAddon(addonJarFile, addonInfo);
        }
        catch (AddonException | IOException e) {
            Logger.global.logError("Failed to load addon '%s'".formatted(addonJarFile), e);
        }
    }

    public static synchronized void loadAddon(Path jarFile, AddonInfo addonInfo) throws AddonException {
        Logger.global.logInfo("Loading BlueMap Addon: %s (%s)".formatted(addonInfo.getId(), jarFile));
        if (LOADED_ADDONS.containsKey(addonInfo.getId())) {
            throw new AddonException("Addon with id '%s' is already loaded".formatted(addonInfo.getId()));
        }
        try {
            Class<?> entrypointClass;
            ClassLoader addonClassLoader = BlueMap.class.getClassLoader();
            try {
                entrypointClass = addonClassLoader.loadClass(addonInfo.getEntrypoint());
            }
            catch (ClassNotFoundException e) {
                addonClassLoader = new URLClassLoader(new URL[]{jarFile.toUri().toURL()}, BlueMap.class.getClassLoader());
                entrypointClass = addonClassLoader.loadClass(addonInfo.getEntrypoint());
            }
            Object instance = entrypointClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            LoadedAddon addon = new LoadedAddon(addonInfo, addonClassLoader, instance);
            LOADED_ADDONS.put(addonInfo.getId(), addon);
            if (instance instanceof Runnable) {
                Runnable runnable = (Runnable)instance;
                runnable.run();
            }
        }
        catch (Exception e) {
            throw new AddonException("Failed to load addon '%s'".formatted(jarFile), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static AddonInfo loadAddonInfo(Path addonJarFile) throws IOException, AddonException {
        try (FileSystem fileSystem = FileSystems.newFileSystem(addonJarFile, (ClassLoader)null);){
            for (Path root : fileSystem.getRootDirectories()) {
                AddonInfo addonInfo;
                Path addonInfoFile = root.resolve("bluemap.addon.json");
                if (!Files.exists(addonInfoFile, new LinkOption[0])) continue;
                BufferedReader reader = Files.newBufferedReader(addonInfoFile, StandardCharsets.UTF_8);
                try {
                    AddonInfo addonInfo2 = (AddonInfo)GSON.fromJson((Reader)reader, AddonInfo.class);
                    if (addonInfo2.getId() == null) {
                        throw new AddonException("'id' is missing");
                    }
                    if (addonInfo2.getEntrypoint() == null) {
                        throw new AddonException("'entrypoint' is missing");
                    }
                    addonInfo = addonInfo2;
                    if (reader == null) return addonInfo;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader == null) throw throwable;
                        try {
                            ((Reader)reader).close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                        return null;
                    }
                }
                ((Reader)reader).close();
                return addonInfo;
            }
        }
    }
}

