/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.api.markers;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.api.markers.DetailMarker;
import de.bluecolored.bluemap.api.markers.DistanceRangedMarker;
import de.bluecolored.bluemap.api.markers.ElementMarker;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class POIMarker
extends DistanceRangedMarker
implements DetailMarker,
ElementMarker {
    private Set<String> classes = new HashSet<String>();
    private String detail;
    private String icon;
    private Vector2i anchor;

    private POIMarker() {
        this("", Vector3d.ZERO);
    }

    public POIMarker(String label, Vector3d position) {
        this(label, position, "assets/poi.svg", new Vector2i(25, 45));
    }

    public POIMarker(String label, Vector3d position, String iconAddress, Vector2i anchor) {
        super("poi", label, position);
        this.detail = Objects.requireNonNull(label, "label must not be null");
        this.icon = Objects.requireNonNull(iconAddress, "iconAddress must not be null");
        this.anchor = Objects.requireNonNull(anchor, "anchor must not be null");
    }

    @Override
    public String getDetail() {
        return this.detail;
    }

    @Override
    public void setDetail(String detail) {
        this.detail = detail;
    }

    public String getIconAddress() {
        return this.icon;
    }

    @Override
    public Vector2i getAnchor() {
        return this.anchor;
    }

    @Override
    public void setAnchor(Vector2i anchor) {
        this.anchor = Objects.requireNonNull(anchor, "anchor must not be null");
    }

    public void setIcon(String iconAddress, int anchorX, int anchorY) {
        this.setIcon(iconAddress, new Vector2i(anchorX, anchorY));
    }

    public void setIcon(String iconAddress, Vector2i anchor) {
        this.icon = Objects.requireNonNull(iconAddress, "iconAddress must not be null");
        this.anchor = Objects.requireNonNull(anchor, "anchor must not be null");
    }

    @Override
    public Collection<String> getStyleClasses() {
        return Collections.unmodifiableCollection(this.classes);
    }

    @Override
    public void setStyleClasses(Collection<String> styleClasses) {
        if (!styleClasses.stream().allMatch(STYLE_CLASS_PATTERN.asMatchPredicate())) {
            throw new IllegalArgumentException("One of the provided style-classes has an invalid format!");
        }
        this.classes.clear();
        this.classes.addAll(styleClasses);
    }

    @Override
    public void addStyleClasses(Collection<String> styleClasses) {
        if (!styleClasses.stream().allMatch(STYLE_CLASS_PATTERN.asMatchPredicate())) {
            throw new IllegalArgumentException("One of the provided style-classes has an invalid format!");
        }
        this.classes.addAll(styleClasses);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        POIMarker poiMarker = (POIMarker)o;
        if (!this.icon.equals(poiMarker.icon)) {
            return false;
        }
        return this.anchor.equals(poiMarker.anchor);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.icon.hashCode();
        result = 31 * result + this.anchor.hashCode();
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated(forRemoval=true)
    public static Builder toBuilder() {
        return new Builder();
    }

    public static class Builder
    extends DistanceRangedMarker.Builder<POIMarker, Builder>
    implements DetailMarker.Builder<Builder>,
    ElementMarker.Builder<Builder> {
        Set<String> classes = new HashSet<String>();
        String detail;
        String icon;
        Vector2i anchor;

        @Override
        public Builder detail(String detail) {
            this.detail = detail;
            return this;
        }

        public Builder icon(String iconAddress, int anchorX, int anchorY) {
            return this.icon(iconAddress, new Vector2i(anchorX, anchorY));
        }

        public Builder icon(String iconAddress, Vector2i anchor) {
            this.icon = Objects.requireNonNull(iconAddress, "iconAddress must not be null");
            this.anchor = Objects.requireNonNull(anchor, "anchor must not be null");
            return this;
        }

        @Override
        public Builder anchor(Vector2i anchor) {
            this.anchor = Objects.requireNonNull(anchor, "anchor must not be null");
            return this;
        }

        public Builder defaultIcon() {
            this.icon = null;
            this.anchor = null;
            return this;
        }

        @Override
        public Builder styleClasses(String ... styleClasses) {
            List<String> styleClassesCollection = Arrays.asList(styleClasses);
            if (!styleClassesCollection.stream().allMatch(ElementMarker.STYLE_CLASS_PATTERN.asMatchPredicate())) {
                throw new IllegalArgumentException("One of the provided style-classes has an invalid format!");
            }
            this.classes.addAll(styleClassesCollection);
            return this;
        }

        @Override
        public Builder clearStyleClasses() {
            this.classes.clear();
            return this;
        }

        @Override
        public POIMarker build() {
            POIMarker marker = new POIMarker(this.checkNotNull(this.label, "label"), this.checkNotNull(this.position, "position"));
            if (this.detail != null) {
                marker.setDetail(this.detail);
            }
            if (this.icon != null) {
                marker.setIcon(this.icon, this.anchor);
            } else if (this.anchor != null) {
                marker.setAnchor(this.anchor);
            }
            marker.setStyleClasses(this.classes);
            return this.build(marker);
        }
    }
}

